/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.units;

import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class MeasuringUnitFormat {
    public static final StringConverter<MeasuringUnitFormat> CONVERTER = new StringConverter<MeasuringUnitFormat>(){

        public String toString(MeasuringUnitFormat object) {
            if (object == null) {
                return null;
            }
            return object.id;
        }

        public MeasuringUnitFormat fromString(String string) {
            if (string == null) {
                return null;
            }
            return MeasuringUnitFormat.getMeasuringUnitFormat(string);
        }
    };
    public static final String DEFAULT_FORMAT_PATTERN = "###,###,###,###,##0.000";
    private final String id;
    private final String name;
    private final String pattern;
    private final DecimalFormat defaultDecimalFormat;

    public MeasuringUnitFormat(String id, String name) {
        this(id, name, null);
    }

    public MeasuringUnitFormat(String id, String name, String defaultDecimalFormat) {
        this.id = id;
        this.name = name;
        if (defaultDecimalFormat != null) {
            this.pattern = defaultDecimalFormat;
            this.defaultDecimalFormat = new DecimalFormat(defaultDecimalFormat);
        } else {
            this.pattern = DEFAULT_FORMAT_PATTERN;
            this.defaultDecimalFormat = new DecimalFormat(DEFAULT_FORMAT_PATTERN);
        }
        MeasuringUnitFormats.FORMATS.put(id, this);
    }

    public String getId() {
        return this.id;
    }

    public String getPattern() {
        return this.pattern;
    }

    public DecimalFormat getDefaultDecimalFormat() {
        return this.defaultDecimalFormat;
    }

    public static MeasuringUnitFormat getMeasuringUnitFormat(String id) {
        if (id == null) {
            return null;
        }
        MeasuringUnitFormat unitFormat = MeasuringUnitFormats.FORMATS.get(id);
        if (unitFormat == null) {
            System.err.println("Unknown measuring unit ID " + id);
        }
        return unitFormat;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MeasuringUnitFormat)) {
            return false;
        }
        return this.id.equals(((MeasuringUnitFormat)obj).id);
    }

    public int hashCode() {
        return MeasuringUnit.class.hashCode() + this.id.hashCode() * 17;
    }

    public String toString() {
        return this.name;
    }
}

