/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.units;

import de.elpro.ewms.core.units.MeasuringUnit;

public class MeasuringUnitValue {
    private final MeasuringUnit measuringUnit;
    private final double value;

    public MeasuringUnitValue(MeasuringUnit measuringUnit, double value) {
        this.measuringUnit = measuringUnit;
        this.value = value;
    }

    public MeasuringUnit getMeasuringUnit() {
        return this.measuringUnit;
    }

    public double getValue() {
        return this.value;
    }

    public MeasuringUnitValue convert(MeasuringUnit toMeasuringUnit) {
        return new MeasuringUnitValue(toMeasuringUnit, toMeasuringUnit.convert(this.value, this.measuringUnit));
    }

    public String toString() {
        return String.format("{muv:%s:%s}", this.measuringUnit.getId(), Double.toString(this.value));
    }

    public static MeasuringUnitValue parse(String s) {
        try {
            String[] parts = s.split(":");
            if (parts.length != 3) {
                throw new IllegalArgumentException();
            }
            if (!"{muv".equals(parts[0]) || !parts[2].endsWith("}")) {
                throw new IllegalArgumentException();
            }
            MeasuringUnit unit = MeasuringUnit.getMeasuringUnit(parts[1]);
            double value = Double.parseDouble(parts[2].substring(0, parts[2].length() - 1));
            return new MeasuringUnitValue(unit, value);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

