/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.units;

import de.elpro.ewms.core.bundle.Activator;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnitDefinition;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.units.UsageDomain;
import de.elpro.ewms.core.units.UsageDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javafx.util.StringConverter;
import javax.persistence.Column;
import org.eclipse.fx.core.log.Logger;

public class PhysicalUnit
implements Comparable<Object> {
    private static final Logger logger = Activator.createLogger(PhysicalUnit.class);
    public static final StringConverter<PhysicalUnit> CONVERTER = new StringConverter<PhysicalUnit>(){

        public String toString(PhysicalUnit object) {
            if (object == null) {
                return null;
            }
            return object.getKey();
        }

        public PhysicalUnit fromString(String idString) {
            if (idString == null) {
                return null;
            }
            return PhysicalUnit.getPhysicalUnit(idString);
        }
    };
    private final String key;
    private final String name;
    private final Aggregation aggregation;
    private final Map<String, MeasuringUnit> predefinedMeasuringUnits = new TreeMap<String, MeasuringUnit>();
    private final Map<String, MeasuringUnit> measuringUnits = new TreeMap<String, MeasuringUnit>();
    private final Map<UsageDomain, MeasuringUnit> domainMeasurementUnits = new HashMap<UsageDomain, MeasuringUnit>();

    protected PhysicalUnit(String key, String name, Aggregation aggregation) {
        this.key = key;
        this.name = name;
        this.aggregation = aggregation;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getName() {
        return this.name;
    }

    @Column(name="aggregation", nullable=false)
    public final Aggregation getAggregation() {
        return this.aggregation;
    }

    public void setDomainMeasurementUnit(UsageDomain domain, MeasuringUnit measuringUnit) {
        if (measuringUnit == null || measuringUnit.getPhysicalUnit() != this) {
            throw new IllegalArgumentException();
        }
        this.domainMeasurementUnits.put(domain, measuringUnit);
    }

    public MeasuringUnit getMeasuringUnit(UsageDomain domain) {
        MeasuringUnit measurementUnit = this.domainMeasurementUnits.get(domain);
        if (measurementUnit == null) {
            measurementUnit = this.domainMeasurementUnits.get(UsageDomains.DEFAULT);
        }
        return measurementUnit;
    }

    public boolean containsMeasuringUnit(String key) {
        return this.measuringUnits.containsKey(key);
    }

    public MeasuringUnit getMeasuringUnit(String key) {
        return this.measuringUnits.get(key);
    }

    public MeasuringUnit getPredefinedMeasuringUnit(String key) {
        return this.predefinedMeasuringUnits.get(key);
    }

    public Collection<MeasuringUnit> getPredefinedMeasuringUnits() {
        return Collections.unmodifiableCollection(this.predefinedMeasuringUnits.values());
    }

    public Collection<MeasuringUnit> getDynamicMeasuringUnits() {
        ArrayList<MeasuringUnit> dynamicMUs = new ArrayList<MeasuringUnit>(this.measuringUnits.values());
        dynamicMUs.removeAll(this.predefinedMeasuringUnits.values());
        return Collections.unmodifiableCollection(dynamicMUs);
    }

    public Collection<MeasuringUnit> getMeasuringUnits() {
        return Collections.unmodifiableCollection(this.measuringUnits.values());
    }

    void clearDynamicMeasuringUnits() {
        Collection<MeasuringUnit> dynamicMeasuringUnits = this.getDynamicMeasuringUnits();
        dynamicMeasuringUnits.forEach(mu -> {
            MeasuringUnit measuringUnit = this.measuringUnits.remove(mu.getKey());
        });
        dynamicMeasuringUnits.forEach(mu -> {
            MeasuringUnit measuringUnit = MeasuringUnit.UNITS.remove(mu.getKey());
        });
    }

    void addPredefinedMeasuringUnit(MeasuringUnit measuringUnit) {
        this.predefinedMeasuringUnits.put(measuringUnit.getKey(), measuringUnit);
    }

    void addMeasuringUnit(MeasuringUnit measuringUnit) {
        this.measuringUnits.put(measuringUnit.getKey(), measuringUnit);
    }

    public static PhysicalUnit getPhysicalUnit(String key) {
        if (key == null) {
            return null;
        }
        PhysicalUnit unit = PhysicalUnitRegistry.getPhysicalUnit(key);
        if (unit == null) {
            logger.errorf("Cannot find physical unit.", (Throwable)new Exception(String.format("Unknown physical unit ID %s", key)), new Object[0]);
            return PhysicalUnit.toUnknownPhysicalUnit(key);
        }
        return unit;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PhysicalUnit)) {
            return false;
        }
        if (this.getKey() == null) {
            return this == obj;
        }
        return this.getKey().equals(((PhysicalUnit)obj).getKey());
    }

    public int hashCode() {
        if (this.getKey() == null) {
            return super.hashCode();
        }
        return PhysicalUnit.class.hashCode() + 17 * this.getKey().hashCode();
    }

    @Override
    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return String.format("%s (%s)", this.name, this.key);
    }

    public PhysicalUnitDefinition toDefinition() {
        PhysicalUnitDefinition pud = new PhysicalUnitDefinition();
        pud.setKey(this.getKey());
        pud.setName(this.getName());
        pud.setAggregation(this.getAggregation());
        for (Map.Entry<UsageDomain, MeasuringUnit> entry : this.domainMeasurementUnits.entrySet()) {
            pud.getDomainMeasurementUnitsIds().put(entry.getKey(), entry.getValue().getId());
        }
        return pud;
    }

    public static final PhysicalUnit toUnknownPhysicalUnit(String key) {
        return new PhysicalUnit(key, "Unknown_" + key.trim().replace(" ", "_"), Aggregation.Avg);
    }
}

