/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.units;

import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.UsageDomain;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_units_physicalunit", uniqueConstraints={@UniqueConstraint(columnNames={"key"})})
@Access(value=AccessType.PROPERTY)
public class PhysicalUnitDefinition
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "units/physical_unit";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty key = new SimpleStringProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<Aggregation> aggregation = new SimpleObjectProperty();
    private final Map<UsageDomain, String> domainMeasurementUnits = new HashMap<UsageDomain, String>();

    public PhysicalUnitDefinition() {
    }

    public PhysicalUnitDefinition(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_units_physicalunit_sequence")
    @SequenceGenerator(name="ewms_units_physicalunit_sequence", sequenceName="ewms_units_physicalunit_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="key", nullable=false)
    public String getKey() {
        return (String)this.key.get();
    }

    public void setKey(String key) {
        this.key.set((Object)key);
    }

    public final StringProperty keyProperty() {
        return this.key;
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="aggregation", nullable=false)
    public Aggregation getAggregation() {
        return (Aggregation)((Object)this.aggregation.get());
    }

    public void setAggregation(Aggregation aggregation) {
        this.aggregation.set((Object)aggregation);
    }

    public final ObjectProperty<Aggregation> aggregationProperty() {
        return this.aggregation;
    }

    @Transient
    public Map<UsageDomain, String> getDomainMeasurementUnitsIds() {
        return this.domainMeasurementUnits;
    }

    public String toString() {
        return this.getKey();
    }

    @Transient
    public Node getGraphic() {
        Label l = new Label();
        l.setText(this.getName());
        l.setStyle("-fx-font-weight: bold; -fx-text-fill: cornflowerblue; -fx-font-style: italic;");
        l.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        return l;
    }

    public boolean equals(Object obj) {
        if (this.getId() == null) {
            return super.equals(obj);
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return PhysicalUnit.class.hashCode() + 17 * this.getId();
    }
}

