/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import java.time.Instant;
import java.util.ArrayList;

public class Aggregator {
    public static IVarValue[] aggregate(IVarValue[] values, Raster raster, VirtualRaster targetRaster, Aggregation aggr) {
        if (raster == Raster.Hour && targetRaster == VirtualRaster.Hour) {
            return values;
        }
        ArrayList<IVarValue> elValues = new ArrayList<IVarValue>(100);
        if (targetRaster == VirtualRaster.Overall) {
            IVarValue[] iVarValueArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                IVarValue val = iVarValueArray[n2];
                elValues.add(val);
                ++n2;
            }
            return new IVarValue[]{aggr.aggregateAndConvert(elValues)};
        }
        long fromTs = raster.getRasterBegin(values[0].getEndTimestamp());
        ArrayList<IVarValue> result = new ArrayList<IVarValue>(values.length);
        Instant nextRasterEnd = targetRaster.getRasterEnd(Instant.ofEpochMilli(fromTs + 1L));
        IVarValue[] iVarValueArray = values;
        int n = values.length;
        int n3 = 0;
        while (n3 < n) {
            IVarValue value = iVarValueArray[n3];
            if (value.getEndTimestamp() <= nextRasterEnd.toEpochMilli()) {
                elValues.add(value);
            } else {
                result.add(aggr.aggregateAndConvert(elValues));
                elValues.clear();
                elValues.add(value);
                nextRasterEnd = targetRaster.getRasterEnd(Instant.ofEpochMilli(value.getEndTimestamp()));
            }
            ++n3;
        }
        if (elValues.size() > 0) {
            result.add(aggr.aggregateAndConvert(elValues));
        }
        return result.toArray(new IVarValue[0]);
    }

    public static IVarValue[] aggregate(IVarValue[] values, Raster raster, Raster targetRaster, Aggregation aggr) {
        if (targetRaster.toMilli() < raster.toMilli()) {
            throw new IllegalArgumentException("Target raster cannot be smaller than values raster");
        }
        if (targetRaster.toMilli() % raster.toMilli() != 0L) {
            throw new IllegalArgumentException(String.format("Target raster %s is not in values raster %s", targetRaster.name(), raster.name()));
        }
        if (raster == targetRaster) {
            return values;
        }
        ArrayList<IVarValue> elValues = new ArrayList<IVarValue>(100);
        long fromTs = raster.getRasterBegin(values[0].getEndTimestamp());
        ArrayList<IVarValue> result = new ArrayList<IVarValue>(values.length);
        long nextRasterEnd = targetRaster.getRasterEnd(fromTs + 1L);
        IVarValue[] iVarValueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IVarValue value = iVarValueArray[n2];
            if (value.getEndTimestamp() <= nextRasterEnd) {
                elValues.add(value);
            } else {
                result.add(aggr.aggregateAndConvert(elValues));
                elValues.clear();
                elValues.add(value);
                nextRasterEnd = targetRaster.getRasterEnd(value.getEndTimestamp());
            }
            ++n2;
        }
        if (elValues.size() > 0) {
            result.add(aggr.aggregateAndConvert(elValues));
        }
        return result.toArray(new IVarValue[0]);
    }

    public static IVarValue[] aggregate(IVarValue[] values, Raster raster, ComplexRaster targetRaster, Aggregation aggr) {
        if (targetRaster.getRaster() != null) {
            return Aggregator.aggregate(values, raster, targetRaster.getRaster(), aggr);
        }
        return Aggregator.aggregate(values, raster, targetRaster.getVirtualRaster(), aggr);
    }
}

