/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.calculated;

import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.calculated.FormulaOperation;
import java.util.Map;

public class FormulaCalculator {
    public static Double calculate(FormulaNode node, Map<String, Double> args) {
        switch (node.getType()) {
            case Constant: {
                return (Double)node.getNodeObject();
            }
            case Parameter: {
                return args.get(node.getNodeValue());
            }
            case Operation: {
                FormulaOperation operation = (FormulaOperation)((Object)node.getNodeObject());
                if (operation == FormulaOperation.Map) {
                    int size = node.getParameters().size();
                    if (size <= 3) {
                        return null;
                    }
                    Double arg = FormulaCalculator.calculate(node.getParameters().get(0), args);
                    if (arg == null) {
                        return null;
                    }
                    int i = 1;
                    while (i < node.getParameters().size()) {
                        if (size <= i + 1) {
                            return null;
                        }
                        Double testValue = FormulaCalculator.calculate(node.getParameters().get(i), args);
                        if (arg instanceof Double && testValue instanceof Double && Double.compare(arg, testValue) == 0) {
                            return FormulaCalculator.calculate(node.getParameters().get(i + 1), args);
                        }
                        if (arg instanceof String && testValue instanceof String && ((String)((Object)arg)).equals(testValue)) {
                            return FormulaCalculator.calculate(node.getParameters().get(i + 1), args);
                        }
                        i += 2;
                    }
                    return null;
                }
                Double[] params = new Double[node.getParameters().size()];
                int i = 0;
                while (i < params.length) {
                    Double valObj = FormulaCalculator.calculate(node.getParameters().get(i), args);
                    if (valObj == null) {
                        return null;
                    }
                    params[i] = valObj;
                    ++i;
                }
                double result = 0.0;
                switch (operation) {
                    case Abs: {
                        if (params.length != 1 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return Math.abs(params[0]);
                    }
                    case Div: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] / params[1];
                    }
                    case Mult: {
                        result = 1.0;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Double paramObj = doubleArray[n2];
                            if (!(paramObj instanceof Double)) {
                                return null;
                            }
                            result *= paramObj.doubleValue();
                            ++n2;
                        }
                        return result;
                    }
                    case Min: {
                        int count = 0;
                        result = Double.POSITIVE_INFINITY;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Double paramObj = doubleArray[n3];
                            if (!(paramObj instanceof Double)) {
                                return null;
                            }
                            result = Math.min(result, paramObj);
                            ++count;
                            ++n3;
                        }
                        if (count > 0) {
                            return result;
                        }
                        return null;
                    }
                    case Max: {
                        int count = 0;
                        result = Double.NEGATIVE_INFINITY;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int n4 = 0;
                        while (n4 < n) {
                            Double paramObj = doubleArray[n4];
                            if (!(paramObj instanceof Double)) {
                                return null;
                            }
                            result = Math.max(result, paramObj);
                            ++count;
                            ++n4;
                        }
                        if (count > 0) {
                            return result;
                        }
                        return null;
                    }
                    case Avg: 
                    case Average: {
                        int count = 0;
                        result = 0.0;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int n5 = 0;
                        while (n5 < n) {
                            Double paramObj = doubleArray[n5];
                            if (!(paramObj instanceof Double)) {
                                return null;
                            }
                            result += paramObj.doubleValue();
                            ++count;
                            ++n5;
                        }
                        if (count > 0) {
                            return result / (double)count;
                        }
                        return null;
                    }
                    case Sum: {
                        result = 0.0;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int paramObj = 0;
                        while (paramObj < n) {
                            Double paramObj2 = doubleArray[paramObj];
                            if (!(paramObj2 instanceof Double)) {
                                return null;
                            }
                            result += paramObj2.doubleValue();
                            ++paramObj;
                        }
                        return result;
                    }
                    case Diff: {
                        int i2 = 0;
                        while (i2 < params.length) {
                            if (!(params[i2] instanceof Double)) {
                                return null;
                            }
                            result = i2 == 0 ? params[i2] : (result -= params[i2].doubleValue());
                            ++i2;
                        }
                        return result;
                    }
                    case Eq: {
                        boolean eq = true;
                        Double prevValue = params[0];
                        int i3 = 1;
                        while (i3 < params.length) {
                            Double nextValue = params[i3];
                            if (prevValue instanceof Double && nextValue instanceof Double) {
                                eq &= Double.compare(prevValue, nextValue) == 0;
                            } else if (prevValue instanceof String && nextValue instanceof String) {
                                eq &= ((String)((Object)prevValue)).equals(nextValue);
                            } else {
                                return null;
                            }
                            ++i3;
                        }
                        return eq ? 1.0 : 0.0;
                    }
                    case And: {
                        boolean and = true;
                        int i4 = 0;
                        while (i4 < params.length) {
                            Double oValue = params[i4];
                            if (oValue instanceof Double) {
                                and &= oValue != 0.0;
                            } else {
                                return null;
                            }
                            ++i4;
                        }
                        return and ? 1.0 : 0.0;
                    }
                    case Or: {
                        boolean or = true;
                        int i5 = 0;
                        while (i5 < params.length) {
                            Double oValue = params[i5];
                            if (oValue instanceof Double) {
                                or |= oValue != 0.0;
                            } else {
                                return null;
                            }
                            ++i5;
                        }
                        return or ? 1.0 : 0.0;
                    }
                    case Not: {
                        if (params.length != 1 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return params[0] == 0.0 ? 1.0 : 0.0;
                    }
                    case If: {
                        if (params.length != 3 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return params[0] != 0.0 ? params[1] : params[2];
                    }
                    case Gt: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] > params[1] ? 1.0 : 0.0;
                    }
                    case Ge: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] >= params[1] ? 1.0 : 0.0;
                    }
                    case Lt: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] < params[1] ? 1.0 : 0.0;
                    }
                    case Le: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] <= params[1] ? 1.0 : 0.0;
                    }
                    case Power: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return Math.pow(params[0], params[1]);
                    }
                    case Sin: {
                        if (params.length != 1 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return Math.sin(params[0]);
                    }
                    case Cos: {
                        if (params.length != 1 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return Math.cos(params[0]);
                    }
                    case Tan: {
                        if (params.length != 1 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return Math.tan(params[0]);
                    }
                }
                return null;
            }
        }
        return null;
    }
}

