/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.calculated;

import de.elpro.ewms.core.variable.calculated.FormulaNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormulaInterpreter {
    private static final String[] OPERANDS = new String[]{">=", "<=", ">", "<", "!=", "==", "&&", "||", "&", "|", "^", "/", "*", "+", "-"};
    private static final String[] OPERAND_NAMES = new String[]{"Ge", "Le", "Gt", "Lt", "NotEq", "Eq", "And", "Or", "BitAnd", "BitOr", "Power", "Div", "Mult", "Sum", "Diff"};
    private static final HashMap<String, String> CONSTANTS = new HashMap();
    private static final Map<String, FormulaNode> CACHE = new HashMap<String, FormulaNode>();

    static {
        CONSTANTS.put("TRUE", "1");
        CONSTANTS.put("FALSE", "0");
        CONSTANTS.put("PI", "3.14159265359");
        CONSTANTS.put("RASTER", "RASTER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static FormulaNode getOperationTreeDeprecated(String formula) {
        if (formula == null) {
            return null;
        }
        formula = formula.replace("\\\"", "\\\u00b0");
        Pattern textContent = Pattern.compile("\\\"[^\\\"]*\\\"");
        Matcher tcm = textContent.matcher(formula);
        int tcmcount = 0;
        HashMap<String, String> tcmDict = new HashMap<String, String>();
        while (tcm.find()) {
            String replText = "T\u00b0" + ++tcmcount + "\u00b0";
            formula = tcm.replaceFirst(replText);
            tcmDict.put(replText, tcm.group());
            tcm = textContent.matcher(formula);
        }
        String trimmedFormula = formula.replace(" ", "").replace("\r", "").replace("\n", "").replace("\t", "");
        for (Map.Entry entry : tcmDict.entrySet()) {
            trimmedFormula = trimmedFormula.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        Map<String, FormulaNode> map = CACHE;
        synchronized (map) {
            FormulaNode cachedNode = CACHE.get(trimmedFormula);
            if (cachedNode != null) {
                return cachedNode;
            }
        }
        try {
            FormulaNode formulaNode = FormulaInterpreter.getInternalOperationTree(trimmedFormula);
            Map<String, FormulaNode> map2 = CACHE;
            synchronized (map2) {
                CACHE.put(trimmedFormula, formulaNode);
            }
            return formulaNode;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static FormulaNode getInternalOperationTree(String formula) {
        try {
            operationParameterContent = Pattern.compile("@[^()\u00b0]*\\)");
            opm = operationParameterContent.matcher(formula);
            opmcount = 0;
            opcDict = new HashMap<String, String>();
            while (opm.find()) {
                formula = opm.replaceFirst("@\u00b0" + ++opmcount + "\u00b0)");
                opcDict.put("@\u00b0" + opmcount + "\u00b0)", opm.group());
                opm = operationParameterContent.matcher(formula);
            }
            referenceSourceContent = Pattern.compile("\\$[^\">]*->\\w*");
            rscm = referenceSourceContent.matcher(formula);
            rscmcount = 0;
            rscmDict = new HashMap<String, String>();
            while (rscm.find()) {
                replText = "R\u00b0" + ++rscmcount + "\u00b0";
                formula = rscm.replaceFirst(replText);
                rscmDict.put(replText, rscm.group());
                rscm = referenceSourceContent.matcher(formula);
            }
            textContent = Pattern.compile("\\\"[^\\\"]*\\\"");
            tcm = textContent.matcher(formula);
            tcmcount = 0;
            tcmDict = new HashMap<String, String>();
            while (tcm.find()) {
                replText = "T\u00b0" + ++tcmcount + "\u00b0";
                formula = tcm.replaceFirst(replText);
                tcmDict.put(replText, tcm.group());
                tcm = textContent.matcher(formula);
            }
            formula = formula.replaceAll("\\s", "");
            formula = FormulaInterpreter.replaceLogic(formula);
            formula = FormulaInterpreter.replaceOperands(formula);
            operationPattern = Pattern.compile("[^(),]*\\([^()]*\\)");
            operationContentPattern = Pattern.compile("\\([^()]*\\)");
            nodes = new HashMap<String, FormulaNode>();
            counter = 0;
            if (formula == null || formula.isEmpty() || formula.contains("(") && formula.contains(")")) ** GOTO lbl92
            if (tcmDict.containsKey(formula.trim())) {
                formula = (String)tcmDict.get(formula.trim());
            }
            if (rscmDict.containsKey(formula.trim())) {
                formula = (String)rscmDict.get(formula.trim());
            }
            return new FormulaNode(formula.trim());
lbl-1000:
            // 1 sources

            {
                formula = formula.trim();
                match = operationPattern.matcher(formula);
                replaceName = "";
                if (match.find()) {
                    opc = operationContentPattern.matcher(match.group());
                    if (!opc.find() || (occontent = (oc = opc.group().replace("(", "").replace(")", "").trim()).split("@")).length == 0) continue;
                    ocvals = occontent[0].split(",");
                    ocParams = new ArrayList<FormulaNode>();
                    var27_29 = ocvals;
                    var26_27 = ocvals.length;
                    var25_25 = 0;
                    while (var25_25 < var26_27) {
                        ocval = var27_29[var25_25];
                        if (ocval != null && !ocval.isEmpty()) {
                            trOcval = ocval.trim();
                            if (FormulaInterpreter.CONSTANTS.containsKey(trOcval)) {
                                trOcval = FormulaInterpreter.CONSTANTS.get(trOcval);
                            }
                            if (tcmDict.containsKey(trOcval)) {
                                trOcval = ((String)tcmDict.get(trOcval)).replace("\\\u00b0", "\\\"");
                            }
                            if (rscmDict.containsKey(trOcval)) {
                                trOcval = (String)rscmDict.get(trOcval);
                            }
                            if ((param = (FormulaNode)nodes.get(trOcval)) == null) {
                                param = new FormulaNode(trOcval);
                            }
                            ocParams.add(param);
                        }
                        ++var25_25;
                    }
                    ocName = match.group().replace(opc.group(), "");
                    if (ocName == null || ocName.isEmpty()) {
                        if (ocParams.size() == 1) {
                            formula = formula.replace(match.group(), oc);
                            continue;
                        }
                        throw new Exception();
                    }
                    if (ocName.startsWith("R\u00b0") && ocName.endsWith("\u00b0")) {
                        ocName = (String)rscmDict.get(ocName);
                    }
                    on = new FormulaNode(ocName.trim(), ocParams);
                    if (occontent.length == 2 && opcDict.containsKey(key = "@" + occontent[1].trim() + ")")) {
                        on.setOperationParameters(((String)opcDict.get(key)).replace("@", "").replace(")", "").trim());
                    }
                    replaceName = "#" + counter++ + "#";
                    nodes.put(replaceName, on);
                    formula = formula.replace(match.group(), replaceName);
                    if (formula.contains("(")) continue;
                    return on;
                }
                return new FormulaNode("");
lbl92:
                // 4 sources

                ** while (formula != null && !formula.isEmpty())
            }
lbl93:
            // 1 sources

            return new FormulaNode("");
        }
        catch (Exception v0) {
            return new FormulaNode("");
        }
    }

    private static String replaceLogic(String formula) {
        Pattern ifRegx = Pattern.compile("^if\\(|[^\\w]if\\(");
        Matcher match = ifRegx.matcher(formula);
        while (match.find()) {
            String falseVal;
            boolean klFalse;
            boolean klTrue;
            String trueVal;
            String formulaPart = formula.substring(match.end() - 1);
            String condition = FormulaInterpreter.getOpContent(formulaPart, '(', ')');
            if (condition == null) {
                return formula;
            }
            if ((formulaPart = formulaPart.substring(condition.length() + 2)).startsWith("{")) {
                trueVal = FormulaInterpreter.getOpContent(formulaPart, '{', '}');
                klTrue = true;
            } else {
                klTrue = false;
                trueVal = formulaPart.substring(0, formulaPart.indexOf("else"));
            }
            if (trueVal == null) {
                return formula;
            }
            if (klTrue && !formulaPart.startsWith("{" + trueVal + "}else") || !klTrue && !formulaPart.startsWith(String.valueOf(trueVal) + "else")) {
                return formula;
            }
            if ((formulaPart = formulaPart.substring(trueVal.length() + (klTrue ? 6 : 4))).startsWith("{")) {
                klFalse = true;
                falseVal = FormulaInterpreter.getOpContent(formulaPart, '{', '}');
            } else {
                klFalse = false;
                falseVal = formulaPart;
            }
            String logicOp = "if(" + condition + ")";
            logicOp = klTrue ? String.valueOf(logicOp) + "{" + trueVal + "}" : String.valueOf(logicOp) + trueVal;
            logicOp = klFalse ? String.valueOf(logicOp) + "else{" + falseVal + "}" : String.valueOf(logicOp) + "else" + falseVal;
            if (!formula.contains(logicOp)) {
                return formula;
            }
            trueVal = FormulaInterpreter.replaceLogic(trueVal);
            falseVal = FormulaInterpreter.replaceLogic(falseVal);
            formula = formula.replace(logicOp, String.format("If(%s,%s,%s)", condition, trueVal, falseVal));
            match = ifRegx.matcher(formula);
        }
        return formula;
    }

    private static String getOpContent(String formula, char startChar, char endChar) {
        int startCCount = 1;
        int endCCount = 0;
        int index = formula.indexOf(startChar);
        while (startCCount != endCCount && ++index < formula.length()) {
            if (formula.charAt(index) == startChar) {
                ++startCCount;
                continue;
            }
            if (formula.charAt(index) != endChar) continue;
            ++endCCount;
        }
        if (index < formula.length()) {
            String output = formula.substring(formula.indexOf(startChar) + 1, index);
            return output;
        }
        return null;
    }

    private static String replaceOperands(String formula) {
        Matcher matcher;
        formula = "(" + formula + ")";
        HashMap<Integer, String> opReplaces = new HashMap<Integer, String>();
        Pattern operationPattern = Pattern.compile("[^(),!=&|<>\\^*/+-]*\\([^()]*\\)");
        Pattern operationContentPattern = Pattern.compile("\\([^()]*\\)");
        Matcher match = operationPattern.matcher(formula);
        int counter = 0;
        while (match.find()) {
            String operation;
            String pOp = operation = match.group();
            String matchText = match.group();
            if (FormulaInterpreter.contains(matchText, OPERANDS)) {
                match = operationContentPattern.matcher(matchText);
                match.find();
                matchText = match.group();
                String opContent = matchText.replace("(", "").replace(")", "").trim();
                String[] opContentParts = opContent.split("@");
                opContent = opContent.replace("@" + opContentParts[opContentParts.length - 1], "");
                String[] opContentParams = opContent.split(",");
                opContent = "";
                String[] stringArray = opContentParams;
                int n = opContentParams.length;
                int n2 = 0;
                while (n2 < n) {
                    String ocp = stringArray[n2];
                    if (opContent != "") {
                        opContent = String.valueOf(opContent) + ",";
                    }
                    opContent = String.valueOf(opContent) + FormulaInterpreter.replaceUnorderedOperands(ocp);
                    ++n2;
                }
                if (opContentParts.length > 1) {
                    opContent = String.valueOf(opContent) + "@" + opContentParts[opContentParts.length - 1];
                }
                pOp = operation != matchText ? String.valueOf(operation.replace(matchText, "")) + "(" + opContent + ")" : opContent;
            }
            opReplaces.put(counter, pOp);
            formula = formula.replace(operation, "#" + counter++ + "#");
            match = operationPattern.matcher(formula);
        }
        Pattern operactionReplacePattert = Pattern.compile("#\\d+#");
        while ((matcher = operactionReplacePattert.matcher(formula)).find()) {
            String pt = matcher.group();
            formula = formula.replace(pt, (CharSequence)opReplaces.get(Integer.parseInt(pt.replace("#", "").trim())));
        }
        while (formula.indexOf(40) == 0) {
            if (formula.lastIndexOf(41) != formula.length() - 1) break;
            formula = formula.substring(1, formula.length() - 1);
        }
        return formula;
    }

    private static boolean contains(String str, String[] teils) {
        String[] stringArray = teils;
        int n = teils.length;
        int n2 = 0;
        while (n2 < n) {
            String teil = stringArray[n2];
            if (str.contains(teil)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static String replaceUnorderedOperands(String formula) {
        i = 0;
        ** GOTO lbl7
        {
            formula = FormulaInterpreter.replaceOperand(formula, FormulaInterpreter.OPERANDS[i], FormulaInterpreter.OPERAND_NAMES[i]);
            do {
                if (formula.contains(FormulaInterpreter.OPERANDS[i])) continue block0;
                ++i;
lbl7:
                // 2 sources

            } while (i < FormulaInterpreter.OPERANDS.length);
        }
        formula = formula.replace("\u00a7Minus", "-");
        return formula;
    }

    private static String replaceOperand(String formula, String operand, String operandName) {
        String[] operandSymbols = new String[]{"!", "=", ">", "<", "^", "*", "+", "/", "&", "|", "-", ","};
        int minusIndex = formula.indexOf("-");
        while (minusIndex >= 0 && minusIndex < formula.length()) {
            if (minusIndex == 0) {
                formula = "\u00a7Minus" + formula.substring(minusIndex + 1);
            } else if (minusIndex != formula.length() - 1) {
                String minusTeil = formula.substring(minusIndex - 1, minusIndex);
                String[] stringArray = operandSymbols;
                int n = operandSymbols.length;
                int n2 = 0;
                while (n2 < n) {
                    String opSymbol = stringArray[n2];
                    if (opSymbol.equals(minusTeil)) {
                        formula = String.valueOf(formula.substring(0, minusIndex)) + "\u00a7Minus" + formula.substring(minusIndex + 1);
                        break;
                    }
                    ++n2;
                }
            }
            minusIndex = formula.indexOf("-", minusIndex + 1);
        }
        int operandIndex = formula.indexOf(operand);
        if (operandIndex < 0) {
            return formula;
        }
        if (operandIndex == 0) {
            return formula.length() > 1 ? formula.substring(1) : "";
        }
        String[] firstVarParts = FormulaInterpreter.split(formula.substring(0, operandIndex), OPERANDS);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(firstVarParts[firstVarParts.length - 1]);
        String formulaPrefix = formula.substring(0, operandIndex).substring(0, operandIndex - ((String)vars.get(0)).length());
        String formulaSuffix = formula.substring(operandIndex + operand.length());
        while (formulaSuffix != null && !formulaSuffix.isEmpty()) {
            operandIndex = formulaSuffix.indexOf(operand);
            firstVarParts = operandIndex >= 0 ? FormulaInterpreter.split(formulaSuffix.substring(0, operandIndex), OPERANDS) : FormulaInterpreter.split(formulaSuffix, OPERANDS);
            if (firstVarParts.length == 0) {
                formulaSuffix = "";
                break;
            }
            if (firstVarParts[0] != null && !firstVarParts[0].isEmpty()) {
                vars.add(firstVarParts[0]);
            }
            if (firstVarParts.length > 1 || operandIndex == -1) {
                formulaSuffix = formulaSuffix.substring(firstVarParts[0].length());
                break;
            }
            formulaSuffix = formulaSuffix.substring(operandIndex + operand.length());
        }
        String operation = String.valueOf(operandName) + "(";
        int i = 0;
        while (i < vars.size()) {
            operation = String.valueOf(operation) + (String)vars.get(i);
            if (i < vars.size() - 1) {
                operation = String.valueOf(operation) + ",";
            }
            ++i;
        }
        operation = String.valueOf(operation) + ")";
        formula = String.valueOf(formulaPrefix) + operation + formulaSuffix;
        return formula;
    }

    public static String[] split(String str, String[] splits) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(str);
        ArrayList<String> result2 = new ArrayList<String>();
        String[] stringArray = splits;
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            Pattern splitPattern = Pattern.compile(split, 16);
            for (String stri : result) {
                String[] stringArray2 = splitPattern.split(stri);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String teil = stringArray2[n4];
                    result2.add(teil);
                    ++n4;
                }
            }
            result.clear();
            result.addAll(result2);
            result2.clear();
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    public static String getConstantValue(String constant) {
        return CONSTANTS.get(constant);
    }
}

