/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;

public class DValArray {
    private final long from;
    private final long to;
    private final double[] values;

    public DValArray(long from, long to, double[] values) {
        if (from >= to) {
            throw new IllegalArgumentException();
        }
        long step = (to - from) / (long)values.length;
        if (step * (long)values.length != to - from) {
            throw new IllegalArgumentException();
        }
        this.from = from;
        this.to = to;
        this.values = values;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public double[] getValues() {
        return this.values;
    }

    public IVarValuesCollection toVarValuesCollection() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IVarValuesCollection result = new IVarValuesCollection();){
            long step = (this.to - this.from) / (long)this.values.length;
            int i = 0;
            while (i < this.values.length) {
                long endTs = this.from + (long)(i + 1) * step;
                double dVal = this.values[i];
                if (Double.isFinite(dVal)) {
                    result.add(new VarValue(endTs, dVal, 1.0, ValueSource.Mixed));
                } else {
                    result.add(VarValue.nan(endTs));
                }
                ++i;
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

