/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.ValueSource;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class MeasuredValue
implements IStoredVarValue {
    public static final int BYTES = 33;
    private long startTimestamp;
    private long endTimestamp;
    private double value;
    private double quality;
    private Plausibility plausibility = Plausibility.Ok;

    public MeasuredValue(long startTimestamp, long endTimestamp, double value, double quality) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.value = value;
        this.quality = quality;
    }

    @Override
    public IVarValue.IVarValueType getType() {
        return IVarValue.IVarValueType.MeasuredValue;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getQuality() {
        return this.quality;
    }

    @Override
    public Plausibility getPlausibility() {
        return this.plausibility;
    }

    @Override
    public ValueSource getValueSource() {
        return ValueSource.Measured;
    }

    @Override
    public MeasuredValue copy(double value) {
        return new MeasuredValue(this.startTimestamp, this.endTimestamp, value, Double.isFinite(value) ? this.quality : 0.0);
    }

    @Override
    public MeasuredValue copyWithTimeShift(double value, long timeShift) {
        MeasuredValue copy = new MeasuredValue(this.startTimestamp + timeShift, this.endTimestamp + timeShift, value, Double.isFinite(value) ? this.quality : 0.0);
        copy.changePlausibility(this.plausibility);
        return copy;
    }

    @Override
    public IVarValue copyWithPlausibility(Plausibility plausibility) {
        MeasuredValue copy = new MeasuredValue(this.startTimestamp, this.endTimestamp, this.value, Double.isFinite(this.value) ? this.quality : 0.0);
        copy.changePlausibility(plausibility);
        return copy;
    }

    @Override
    public boolean metadataEqualWithTimeOffet(IVarValue varValue, long offset) {
        if (MeasuredValue.class != varValue.getClass()) {
            return false;
        }
        MeasuredValue mv = (MeasuredValue)varValue;
        return this.quality == mv.getQuality() && this.startTimestamp + offset == mv.startTimestamp && this.endTimestamp + offset == mv.endTimestamp;
    }

    @Override
    public void changePlausibility(Plausibility plausibility) {
        this.plausibility = plausibility;
    }

    @Override
    public IStoredVarValue copy(long startTimestamp, long endTimestamp, double value, double quality, Plausibility plausibility) {
        return new MeasuredValue(startTimestamp, endTimestamp, value, quality);
    }

    public String toString() {
        return String.format("%s-%s %f", LocalDateTime.ofInstant(Instant.ofEpochMilli(this.startTimestamp), ZoneId.systemDefault()), LocalDateTime.ofInstant(Instant.ofEpochMilli(this.endTimestamp), ZoneId.systemDefault()), this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IVarValue)) {
            return false;
        }
        if (this.getType() != ((IVarValue)obj).getType()) {
            return false;
        }
        MeasuredValue other = (MeasuredValue)obj;
        return this.startTimestamp == other.startTimestamp && this.endTimestamp == other.endTimestamp && this.equalValue(other) && this.quality == other.quality && this.plausibility == other.plausibility;
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.putLong(this.startTimestamp);
        buffer.putLong(this.endTimestamp);
        buffer.putDouble(this.value);
        buffer.putDouble(this.quality);
        buffer.put((byte)this.plausibility.ordinal());
    }

    public static MeasuredValue read(ByteBuffer buffer) {
        MeasuredValue mv = new MeasuredValue(buffer.getLong(), buffer.getLong(), buffer.getDouble(), buffer.getDouble());
        mv.changePlausibility(Plausibility.values()[buffer.get()]);
        return mv;
    }
}

