/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import java.nio.ByteBuffer;

public class StoredVarValue
extends VarValue
implements IStoredVarValue {
    public static final int BYTES = 34;
    private long startTimestamp;

    public StoredVarValue(long startTimestamp, long endTimestamp, double value, double quality, ValueSource valueSource) {
        this(startTimestamp, endTimestamp, value, quality, Plausibility.Ok, valueSource);
    }

    public StoredVarValue(long startTimestamp, long endTimestamp, double value, double quality, Plausibility plausibility, ValueSource valueSource) {
        super(endTimestamp, value, quality, plausibility, valueSource);
        this.startTimestamp = startTimestamp;
    }

    @Override
    public IVarValue.IVarValueType getType() {
        return IVarValue.IVarValueType.StoredVarValue;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public static IStoredVarValue nan(long startTimestamp, long endTimestamp) {
        return new StoredVarValue(startTimestamp, endTimestamp, Double.NaN, -1.0, Plausibility.Missing, ValueSource.NaN);
    }

    @Override
    public boolean metadataEqualWithTimeOffet(IVarValue varValue, long offset) {
        if (StoredVarValue.class != varValue.getClass()) {
            return false;
        }
        StoredVarValue av = (StoredVarValue)varValue;
        return this.getQuality() == av.getQuality() && this.getPlausibility() == av.getPlausibility() && this.getValueSource() == av.getValueSource() && this.getStartTimestamp() + offset == av.getStartTimestamp() && this.getEndTimestamp() + offset == av.getEndTimestamp();
    }

    @Override
    public IStoredVarValue copy(long newStartTimestamp, long newEndTimestamp, double newValue, double quality, Plausibility plausibility) {
        return new StoredVarValue(newStartTimestamp, newEndTimestamp, newValue, quality, this.getValueSource());
    }

    @Override
    public IVarValue copy(long endTimestamp) {
        return this.copyWithTimeShift(0L);
    }

    @Override
    public IVarValue copyWithTimeShift(long timeShift) {
        return this.copyWithTimeShift(this.getValue(), timeShift);
    }

    @Override
    public StoredVarValue copyWithTimeShift(double value, long timeShift) {
        return new StoredVarValue(this.getStartTimestamp() + timeShift, this.getEndTimestamp() + timeShift, value, Double.isFinite(value) ? this.getQuality() : 0.0, this.getValueSource());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IVarValue)) {
            return false;
        }
        if (this.getType() != ((IVarValue)obj).getType()) {
            return false;
        }
        StoredVarValue other = (StoredVarValue)obj;
        return this.startTimestamp == other.startTimestamp && this.getEndTimestamp() == other.getEndTimestamp() && this.equalValue(other) && this.getQuality() == other.getQuality() && this.getPlausibility() == other.getPlausibility() && this.getValueSource() == other.getValueSource();
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.putLong(this.startTimestamp);
        super.write(buffer);
    }

    public static StoredVarValue read(ByteBuffer buffer) {
        return new StoredVarValue(buffer.getLong(), buffer.getLong(), buffer.getDouble(), buffer.getDouble(), Plausibility.values()[buffer.get()], ValueSource.values()[buffer.get()]);
    }
}

