/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.IVarValuesCollectionCluster;
import de.elpro.ewms.core.variable.value.IVarValuesCollectionSpliterator;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMapCluster;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMapClustered;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class VarInstanceValuesCollectionMapSpliterator
implements Iterator<VarInstanceValuesCollectionMapCluster> {
    private final Raster clusterSize;
    private final Map<VariableInstance, IVarValuesCollectionSpliterator> variableInstancesSpliterators = new HashMap<VariableInstance, IVarValuesCollectionSpliterator>();
    private boolean hasNext = false;
    private Long clusterBeginTs = null;
    private final Map<VariableInstance, IVarValuesCollectionCluster> nextClusters = new HashMap<VariableInstance, IVarValuesCollectionCluster>();

    public VarInstanceValuesCollectionMapSpliterator(Raster clusterSize, Map<VariableInstance, IVarValuesCollection> instanceValues) {
        this.clusterSize = clusterSize;
        for (Map.Entry<VariableInstance, IVarValuesCollection> entry : instanceValues.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            IVarValuesCollectionSpliterator spliterator = new IVarValuesCollectionSpliterator(clusterSize, entry.getValue());
            this.variableInstancesSpliterators.put(entry.getKey(), spliterator);
            this.hasNext |= spliterator.hasNext();
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public VarInstanceValuesCollectionMapCluster next() {
        IVarValuesCollectionSpliterator spliterator;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        if (this.clusterBeginTs == null) {
            for (Map.Entry<VariableInstance, IVarValuesCollectionSpliterator> entry : this.variableInstancesSpliterators.entrySet()) {
                VariableInstance instance = entry.getKey();
                spliterator = entry.getValue();
                if (!spliterator.hasNext()) continue;
                IVarValuesCollectionCluster nextInstanceCluster = spliterator.next();
                this.clusterBeginTs = this.clusterBeginTs == null ? Long.valueOf(nextInstanceCluster.getClusterBeginTs()) : Long.valueOf(Math.min(this.clusterBeginTs, nextInstanceCluster.getClusterBeginTs()));
                this.nextClusters.put(instance, nextInstanceCluster);
            }
        }
        HashMap<VariableInstance, IVarValuesCollection> clusterInstanceValues = new HashMap<VariableInstance, IVarValuesCollection>();
        for (Map.Entry<VariableInstance, IVarValuesCollectionCluster> entry : this.nextClusters.entrySet()) {
            VariableInstance instance = entry.getKey();
            IVarValuesCollectionCluster valuesCluster = entry.getValue();
            if (valuesCluster.getClusterBeginTs() != this.clusterBeginTs.longValue()) continue;
            clusterInstanceValues.put(instance, valuesCluster.getClusterValues());
        }
        for (VariableInstance instance : clusterInstanceValues.keySet()) {
            spliterator = this.variableInstancesSpliterators.get((Object)instance);
            if (spliterator.hasNext()) {
                this.nextClusters.put(instance, spliterator.next());
                continue;
            }
            this.nextClusters.remove((Object)instance);
        }
        VarInstanceValuesCollectionMapCluster result = new VarInstanceValuesCollectionMapCluster(this.clusterBeginTs, this.clusterSize, clusterInstanceValues);
        this.clusterBeginTs = Long.MAX_VALUE;
        this.hasNext = false;
        for (IVarValuesCollectionCluster valuesCluster : this.nextClusters.values()) {
            this.clusterBeginTs = Math.min(this.clusterBeginTs, valuesCluster.getClusterBeginTs());
            this.hasNext = true;
        }
        return result;
    }

    public static void main(String[] args) {
        HashMap<VariableInstance, IVarValuesCollection> instanceValues = new HashMap<VariableInstance, IVarValuesCollection>();
        int j = 2;
        while (j < 6) {
            IVarValuesCollection iVarValuesCollection;
            VariableInstance instance = new VariableInstance(j);
            Object object = null;
            Object var6_10 = null;
            try (IVarValuesCollection newColl = new IVarValuesCollection();){
                int i = 0;
                while (i < 10) {
                    if (i % j != 0) {
                        newColl.add(new MeasuredValue(i * 10, (i + 1) * 10, i + j, 1.0));
                    }
                    ++i;
                }
                iVarValuesCollection = newColl;
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            instanceValues.put(instance, iVarValuesCollection);
            ++j;
        }
        for (VarInstanceValuesCollectionMapCluster cluster : new VarInstanceValuesCollectionMapClustered(Raster.Milli_20, instanceValues)) {
            System.out.println(cluster.getClusterBeginTs());
            for (Map.Entry entry : cluster.getInstanceValues().entrySet()) {
                System.out.println(((VariableInstance)((Object)entry.getKey())).getId() + ": " + ((IVarValuesCollection)entry.getValue()).toString());
            }
        }
    }
}

