/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ui.formats.TimeFormatType;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;

public class VarValue
implements IVarValue {
    public static final int BYTES = 26;
    private long endTimestamp;
    private double value;
    private double quality;
    private Plausibility plausibility;
    private ValueSource source;

    public VarValue(long endTimestamp, double value, double quality, ValueSource valueSource) {
        this(endTimestamp, value, quality, Plausibility.Ok, valueSource);
    }

    public VarValue(long endTimestamp, double value, double quality, Plausibility plausibility, ValueSource valueSource) {
        this.endTimestamp = endTimestamp;
        this.value = value;
        this.quality = quality;
        this.plausibility = plausibility;
        this.source = valueSource;
    }

    @Override
    public IVarValue.IVarValueType getType() {
        return IVarValue.IVarValueType.VarValue;
    }

    @Override
    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getQuality() {
        return this.quality;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setQuality(double quality) {
        this.quality = quality;
    }

    @Override
    public Plausibility getPlausibility() {
        return this.plausibility;
    }

    public void setPlausibility(Plausibility plausibility) {
        this.plausibility = plausibility;
    }

    @Override
    public void changePlausibility(Plausibility plausibility) {
        this.plausibility = plausibility;
    }

    @Override
    public ValueSource getValueSource() {
        return this.source;
    }

    public void setValueSource(ValueSource valueSource) {
        this.source = valueSource;
    }

    @Override
    public boolean metadataEqualWithTimeOffet(IVarValue varValue, long offset) {
        if (VarValue.class != varValue.getClass()) {
            return false;
        }
        VarValue av = (VarValue)varValue;
        return this.quality == av.getQuality() && this.plausibility == av.plausibility && this.source == av.source && this.endTimestamp + offset == av.endTimestamp;
    }

    @Override
    public IVarValue copy() {
        return new VarValue(this.endTimestamp, this.value, this.quality, this.plausibility, this.source);
    }

    @Override
    public IVarValue copy(double value) {
        return new VarValue(this.endTimestamp, value, this.quality, this.plausibility, this.source);
    }

    @Override
    public IVarValue copy(long endTimestamp) {
        return new VarValue(endTimestamp, this.value, this.quality, this.plausibility, this.source);
    }

    @Override
    public IVarValue copyWithTimeShift(long timeShift) {
        return this.copy(this.endTimestamp + timeShift);
    }

    @Override
    public IVarValue copyWithTimeShift(double value, long timeShift) {
        return new VarValue(this.endTimestamp + timeShift, value, Double.isFinite(value) ? this.quality : 0.0, this.plausibility, this.source);
    }

    @Override
    public IVarValue copyWithPlausibility(Plausibility plausibility) {
        return new VarValue(this.endTimestamp, this.value, Double.isFinite(this.value) ? this.quality : 0.0, plausibility, this.source);
    }

    public String toString() {
        return String.format("%s %f", TimeFormatType.DateTimeHMsMs.format((TemporalAccessor)LocalDateTime.ofInstant(Instant.ofEpochMilli(this.endTimestamp), ZoneOffset.systemDefault())), this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IVarValue)) {
            return false;
        }
        if (this.getType() != ((IVarValue)obj).getType()) {
            return false;
        }
        VarValue other = (VarValue)obj;
        return this.endTimestamp == other.endTimestamp && this.equalValue(other) && this.quality == other.quality && this.plausibility == other.plausibility && this.source == other.source;
    }

    public static IVarValue nan(long endTimestamp) {
        return new VarValue(endTimestamp, Double.NaN, -1.0, Plausibility.Missing, ValueSource.NaN);
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.putLong(this.endTimestamp);
        buffer.putDouble(this.value);
        buffer.putDouble(this.quality);
        buffer.put((byte)this.plausibility.ordinal());
        buffer.put((byte)this.source.ordinal());
    }

    public static VarValue read(ByteBuffer buffer) {
        return new VarValue(buffer.getLong(), buffer.getDouble(), buffer.getDouble(), Plausibility.values()[buffer.get()], ValueSource.values()[buffer.get()]);
    }
}

