/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.virtualtime;

import de.elpro.ewms.core.Messages;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ui.formats.TimeFormatType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;

public enum VirtualRaster {
    Hour,
    Day,
    Week,
    Month,
    Year,
    Overall;


    public Instant getRasterBegin(Instant utc) {
        return this.getRasterBegin(VirtualZone.INSTANCE, utc);
    }

    public Instant getRasterBegin(VirtualZone virtualZone, Instant utc) {
        int offsetSeconds = virtualZone.getOffsetSeconds(utc);
        ZonedDateTime zonedDateTime = virtualZone.getZonedDateTime(utc);
        switch (this) {
            case Hour: {
                ZonedDateTime rasterBegin = zonedDateTime.withMinute(0).withSecond(0).withNano(0);
                if (!zonedDateTime.isAfter(rasterBegin)) {
                    rasterBegin = rasterBegin.plusHours(-1L);
                }
                return rasterBegin.plusNanos(1L).toInstant();
            }
            case Day: {
                ZonedDateTime rasterBegin = zonedDateTime.withMinute(0).withSecond(0).withNano(0).withHour(0 + offsetSeconds / 3600);
                if (!zonedDateTime.isAfter(rasterBegin)) {
                    rasterBegin = rasterBegin.plusDays(-1L);
                }
                return rasterBegin.plusNanos(1L).toInstant();
            }
            case Week: {
                ZonedDateTime rasterBegin = zonedDateTime.minusDays(zonedDateTime.getDayOfWeek().ordinal()).withMinute(0).withSecond(0).withNano(0).withHour(0 + offsetSeconds / 3600);
                if (!zonedDateTime.isAfter(rasterBegin)) {
                    rasterBegin = rasterBegin.plusDays(-7L);
                }
                return rasterBegin.plusNanos(1L).toInstant();
            }
            case Month: {
                ZonedDateTime rasterBegin = zonedDateTime.withDayOfMonth(1).withMinute(0).withSecond(0).withNano(0).withHour(0 + offsetSeconds / 3600);
                if (!zonedDateTime.isAfter(rasterBegin)) {
                    rasterBegin = rasterBegin.plusMonths(-1L);
                }
                return rasterBegin.plusNanos(1L).toInstant();
            }
            case Year: {
                ZonedDateTime rasterBegin = zonedDateTime.withDayOfYear(1).withMinute(0).withSecond(0).withNano(0).withHour(0 + offsetSeconds / 3600);
                if (!zonedDateTime.isAfter(rasterBegin)) {
                    rasterBegin = rasterBegin.plusYears(-1L);
                }
                return rasterBegin.plusNanos(1L).toInstant();
            }
            case Overall: {
                return Instant.MIN;
            }
        }
        return null;
    }

    public Instant getRasterEnd(Instant utc) {
        return this.getRasterEnd(VirtualZone.INSTANCE, utc);
    }

    public Instant getRasterEnd(VirtualZone virtualZone, Instant utc) {
        int offsetSeconds = virtualZone.getOffsetSeconds(utc);
        ZonedDateTime zonedDateTime = virtualZone.getZonedDateTime(utc);
        switch (this) {
            case Hour: {
                ZonedDateTime rasterEnd = zonedDateTime.withMinute(0).withSecond(0).withNano(0);
                if (rasterEnd.isBefore(zonedDateTime)) {
                    rasterEnd = rasterEnd.plusHours(1L);
                }
                return rasterEnd.toInstant();
            }
            case Day: {
                ZonedDateTime rasterEnd = zonedDateTime.withMinute(0).withSecond(0).withNano(0).withHour(0 + offsetSeconds / 3600);
                if (rasterEnd.isBefore(zonedDateTime)) {
                    rasterEnd = rasterEnd.plusDays(1L);
                }
                return rasterEnd.toInstant();
            }
            case Week: {
                ZonedDateTime rasterEnd = zonedDateTime.minusDays(zonedDateTime.getDayOfWeek().ordinal()).withMinute(0).withSecond(0).withNano(0).withHour(0 + offsetSeconds / 3600);
                if (rasterEnd.isBefore(zonedDateTime)) {
                    rasterEnd = rasterEnd.plusDays(7L);
                }
                return rasterEnd.toInstant();
            }
            case Month: {
                ZonedDateTime rasterEnd = zonedDateTime.withDayOfMonth(1).withMinute(0).withSecond(0).withNano(0).withHour(0 + offsetSeconds / 3600);
                if (rasterEnd.isBefore(zonedDateTime)) {
                    rasterEnd = rasterEnd.plusMonths(1L);
                }
                return rasterEnd.toInstant();
            }
            case Year: {
                ZonedDateTime rasterEnd = zonedDateTime.withDayOfYear(1).withMinute(0).withSecond(0).withNano(0).withHour(0 + offsetSeconds / 3600);
                if (rasterEnd.isBefore(zonedDateTime)) {
                    rasterEnd = rasterEnd.plusYears(1L);
                }
                return rasterEnd.toInstant();
            }
            case Overall: {
                return Instant.MAX;
            }
        }
        return null;
    }

    public long getRasterWidthTotalMillis(Instant utc) {
        Instant rasterBegin = this.getRasterBegin(utc);
        Instant rasterEnd = this.getRasterEnd(utc);
        return rasterEnd.toEpochMilli() - rasterBegin.minusNanos(1L).toEpochMilli();
    }

    public int getSubIndexWithinParentRaster(Instant instant) {
        Instant rasterBegin = this.getRasterBegin(instant);
        OffsetDateTime offsetDateTime = VirtualZone.INSTANCE.getOffsetDateTime(rasterBegin);
        switch (this) {
            case Hour: {
                return offsetDateTime.getHour();
            }
            case Day: {
                return offsetDateTime.getDayOfMonth();
            }
            case Week: {
                return offsetDateTime.getDayOfWeek().getValue();
            }
            case Month: {
                return offsetDateTime.getMonthValue();
            }
            case Year: {
                return offsetDateTime.getYear();
            }
        }
        throw new UnsupportedOperationException("Unsupported Raster");
    }

    public String getSubIndexLabelWithinParentRaster(Instant instant) {
        Instant rasterBegin = this.getRasterBegin(instant);
        OffsetDateTime offsetDateTime = VirtualZone.INSTANCE.getOffsetDateTime(rasterBegin);
        switch (this) {
            case Hour: {
                return String.format("%02d:00", offsetDateTime.getHour());
            }
            case Day: {
                return Integer.toString(offsetDateTime.getDayOfMonth());
            }
            case Week: {
                return TimeFormatType.Week.format((TemporalAccessor)offsetDateTime);
            }
            case Month: {
                return offsetDateTime.getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault());
            }
            case Year: {
                return Integer.toString(offsetDateTime.getYear());
            }
        }
        throw new UnsupportedOperationException("Unsupported Raster");
    }

    public static Instant getDayStart(LocalDate localDate) {
        Instant localInstant = VirtualZone.INSTANCE.getStartOfDay(localDate).plusNanos(1L);
        return localInstant;
    }

    public static Instant getDayEnd(LocalDate localDate) {
        return Day.getRasterEnd(VirtualRaster.getDayStart(localDate));
    }

    public TimeFormatType getDefaultFormatType() {
        switch (this) {
            case Hour: {
                return TimeFormatType.DateTimeHM;
            }
            case Day: {
                return TimeFormatType.Date;
            }
            case Week: {
                return TimeFormatType.YearWeek;
            }
            case Month: {
                return TimeFormatType.YearMonth;
            }
            case Year: {
                return TimeFormatType.Year;
            }
        }
        throw new UnsupportedOperationException("Unsupported Raster");
    }

    public String getLabel(Instant instant) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return this.getDefaultFormatType().format((TemporalAccessor)localDateTime);
    }

    public String toString() {
        switch (this) {
            case Hour: {
                return Messages.virtualtime_VirtualRaster_Hour;
            }
            case Day: {
                return Messages.virtualtime_VirtualRaster_Day;
            }
            case Week: {
                return Messages.virtualtime_VirtualRaster_Week;
            }
            case Month: {
                return Messages.virtualtime_VirtualRaster_Month;
            }
            case Year: {
                return Messages.virtualtime_VirtualRaster_Year;
            }
            case Overall: {
                return Messages.virtualtime_VirtualRaster_Overall;
            }
        }
        return this.name();
    }
}

