/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.virtualtime;

import de.elpro.ewms.core.virtualtime.ZoneIdWithOffset;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class VirtualZone {
    public static final VirtualZone INSTANCE = new VirtualZone();
    private TreeMap<Instant, ZoneIdWithOffset> zoneOffsetToUtc = new TreeMap();

    public void addZoneOffset(Instant fromUtc, ZoneId zoneId, ZoneOffset zoneOffset) {
        this.zoneOffsetToUtc.put(fromUtc, new ZoneIdWithOffset(zoneId, zoneOffset));
    }

    public void addZoneOffset(Instant fromUtc, ZoneIdWithOffset zoneIdWithOffset) {
        this.zoneOffsetToUtc.put(fromUtc, zoneIdWithOffset);
    }

    public Map<Instant, ZoneIdWithOffset> getZoneOffsets() {
        return Collections.unmodifiableMap(this.zoneOffsetToUtc);
    }

    public void setZoneOffsets(Map<Instant, ZoneIdWithOffset> offsets) {
        this.zoneOffsetToUtc.clear();
        for (Map.Entry<Instant, ZoneIdWithOffset> entry : offsets.entrySet()) {
            this.zoneOffsetToUtc.put(entry.getKey(), entry.getValue());
        }
    }

    private ZoneIdWithOffset getVirtualZone(Instant utc) {
        try {
            Map.Entry<Instant, ZoneIdWithOffset> entry = this.zoneOffsetToUtc.floorEntry(utc);
            if (entry != null) {
                return entry.getValue();
            }
        }
        catch (NullPointerException exc) {
            exc.printStackTrace();
        }
        throw new IllegalArgumentException("No Virtual Zone defined for UTC time " + utc);
    }

    ZonedDateTime getZonedDateTime(Instant utc) {
        ZoneIdWithOffset zoneIdWithOffset = this.getVirtualZone(utc);
        return utc.atZone(zoneIdWithOffset.zoneId);
    }

    int getOffsetSeconds(Instant utc) {
        ZoneIdWithOffset zoneIdWithOffset = this.getVirtualZone(utc);
        return zoneIdWithOffset.zoneOffset.getTotalSeconds();
    }

    public OffsetDateTime getOffsetDateTime(Instant utc) {
        ZoneIdWithOffset zoneIdWithOffset = this.getVirtualZone(utc);
        ZonedDateTime vzdt = utc.atZone(zoneIdWithOffset.zoneId);
        int zoneIdOffsetTotalSeconds = (int)((vzdt.toLocalDateTime().toInstant(ZoneOffset.UTC).toEpochMilli() - utc.toEpochMilli()) / 1000L);
        int virtualZoneOffsetTotalSeconds = zoneIdOffsetTotalSeconds - zoneIdWithOffset.zoneOffset.getTotalSeconds();
        ZoneOffset totalOffset = ZoneOffset.ofTotalSeconds(virtualZoneOffsetTotalSeconds);
        return OffsetDateTime.of(utc.plusSeconds(virtualZoneOffsetTotalSeconds).atOffset(ZoneOffset.UTC).toLocalDateTime(), totalOffset);
    }

    public Instant getStartOfDay(LocalDate localDate) {
        ZoneIdWithOffset zoneIdWithOffset = this.getVirtualZone(localDate.atStartOfDay().toInstant(ZoneOffset.UTC));
        Instant ts = localDate.atStartOfDay(zoneIdWithOffset.zoneId).toInstant().plusSeconds(zoneIdWithOffset.zoneOffset.getTotalSeconds());
        return ts;
    }

    public void init(String str) throws IllegalArgumentException {
        String[] zoneOffsetStrs;
        this.zoneOffsetToUtc.clear();
        String[] stringArray = zoneOffsetStrs = str.split(";");
        int n = zoneOffsetStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String zoneOffsetStr = stringArray[n2];
            if (!zoneOffsetStr.trim().isEmpty()) {
                String[] parts = zoneOffsetStr.split("\\|");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Cannot read VirtualZoneOffset");
                }
                this.addZoneOffset(Instant.parse(parts[0].trim()), ZoneIdWithOffset.parse(parts[1].trim()));
            }
            ++n2;
        }
    }

    public String toString() {
        String result = "";
        for (Map.Entry<Instant, ZoneIdWithOffset> entry : this.zoneOffsetToUtc.entrySet()) {
            result = String.valueOf(result) + String.format("%s|%s; ", entry.getKey(), entry.getValue());
        }
        return result;
    }
}

