/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.worker;

import de.elpro.ewms.core.worker.ExecutionResult;
import de.elpro.ewms.core.worker.WorkerState;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractWorker {
    private final ReentrantLock executionLock = new ReentrantLock();
    private final String id;
    private final String name;
    private final long executionInterval;
    private final Instant creationTimestamp;
    private volatile boolean pendingStop = false;
    private volatile boolean pendingPause = false;
    private Callable<Void> workTask;
    private volatile Thread workerThread;
    private final boolean rasterizedExecution;
    private volatile boolean autostart = false;
    private volatile CallableTask<WorkerState> startingTask;
    private volatile WorkerState state = WorkerState.New;
    private volatile ExecutionResult lastExecutionResult = ExecutionResult.None;
    private volatile long lastExecution = 0L;
    private volatile long lastExecutionDuration = 0L;
    private volatile long nextExecution = 0L;
    private volatile long executionCounter = 0L;
    private volatile Duration totalUtilization = Duration.ZERO;
    private volatile int errorEscalationThreshold = 0;
    private volatile int errorIncrement = 1;
    private volatile int errorDecrement = 0;
    private volatile int errorCount = 0;

    public AbstractWorker(String id, String name, long executionInterval, boolean rasterizedExecution) {
        this.id = id;
        this.name = name;
        this.executionInterval = executionInterval;
        this.rasterizedExecution = rasterizedExecution;
        this.creationTimestamp = Instant.now();
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final long getExecutionInterval() {
        return this.executionInterval;
    }

    public final boolean isAutostart() {
        return this.autostart;
    }

    public final void setAutostart(boolean autostart) {
        this.autostart = autostart;
        WorkerState state = this.getState();
        if (autostart && (state == WorkerState.New || state == WorkerState.Stopped)) {
            this.startAsync();
        }
    }

    public int getErrorEscalationThreshold() {
        return this.errorEscalationThreshold;
    }

    public void setErrorEscalationThreshold(int errorEscalationThreshold) {
        this.errorEscalationThreshold = errorEscalationThreshold;
    }

    public int getErrorIncrement() {
        return this.errorIncrement;
    }

    public void setErrorIncrement(int errorInctement) {
        this.errorIncrement = errorInctement;
    }

    public int getErrorDecrement() {
        return this.errorDecrement;
    }

    public void setErrorDecrement(int errorDecrement) {
        this.errorDecrement = errorDecrement;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public final WorkerState getState() {
        return this.state;
    }

    private void setState(WorkerState state) {
        this.state = state;
    }

    public ExecutionResult getLastExecutionResult() {
        return this.lastExecutionResult;
    }

    public long getLastExecution() {
        return this.lastExecution;
    }

    public long getLastExecutionDuration() {
        return this.lastExecutionDuration;
    }

    public long getNextExecution() {
        return this.nextExecution;
    }

    private void setNextExecution(long nextExecution) {
        this.nextExecution = nextExecution;
    }

    public long getExecutionCounter() {
        return this.executionCounter;
    }

    public Duration getTotalAge() {
        return Duration.between(this.creationTimestamp, Instant.now());
    }

    public Duration getTotalUtilization() {
        return this.totalUtilization;
    }

    protected void onErrorEscalation() {
    }

    private boolean isErrorEscalation() {
        return this.errorEscalationThreshold > 0 && this.errorCount >= this.errorEscalationThreshold;
    }

    protected void setExecutionResult(ExecutionResult executionResult) {
        this.lastExecutionResult = executionResult;
    }

    public final Future<WorkerState> startAsync() {
        if (this.startingTask != null) {
            return null;
        }
        this.startingTask = new CallableTask<WorkerState>(){
            {
                this.updateTitle(String.format("Start '%s' task", AbstractWorker.this.name));
            }

            public WorkerState call() throws Exception {
                boolean result = AbstractWorker.this.doStart();
                while (!result && AbstractWorker.this.isAutostart() && !AbstractWorker.this.pendingStop) {
                    AbstractWorker.this.doStop();
                    this.updateMessage("Cannot start task. Restart in 10 seconds.");
                    Thread.sleep(10000L);
                    result = AbstractWorker.this.doStart();
                }
                if (result) {
                    AbstractWorker.this.workTask = AbstractWorker.this.createWorkTask();
                    AbstractWorker.this.workerThread = new Thread((Runnable)new Worker(), AbstractWorker.this.getName());
                    AbstractWorker.this.setState(WorkerState.Running);
                    AbstractWorker.this.workerThread.start();
                } else {
                    AbstractWorker.this.setState(WorkerState.Stopped);
                }
                return AbstractWorker.this.getState();
            }
        };
        while (this.workerThread != null) {
            this.stopSync();
        }
        this.errorCount = 0;
        this.pendingStop = false;
        this.pendingPause = false;
        this.setState(WorkerState.Starting);
        this.setExecutionResult(ExecutionResult.None);
        this.setNextExecution(0L);
        TaskUtils.ConsumableFuture consumableFuture = TaskUtils.executeUITask(this.startingTask);
        consumableFuture.consumeResult((state, status) -> {
            TaskUtils.removeTaskFromView(this.startingTask);
            this.startingTask = null;
        });
        return consumableFuture.getFuture();
    }

    public final WorkerState startSync() {
        try {
            return this.startAsync().get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return this.getState();
        }
    }

    public final void pause() {
        this.pendingPause = true;
        this.pendingStop = false;
        this.wake();
    }

    public final void resume() {
        this.pendingPause = false;
        this.wake();
    }

    public final void stopAsync() {
        if (this.state == WorkerState.New) {
            return;
        }
        this.pendingStop = true;
        this.pendingPause = false;
        this.wake();
    }

    public final void wake() {
        if (this.workTask != null && this.workerThread != null && this.executionLock.tryLock()) {
            try {
                this.workerThread.interrupt();
            }
            finally {
                this.executionLock.unlock();
            }
        }
    }

    public final void stopSync() {
        this.stopAsync();
        while (this.state != WorkerState.Stopped && this.state != WorkerState.Interrupted && this.state != WorkerState.New) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public final void terminate() {
        this.stopSync();
        this.workTask = null;
    }

    public final Future<WorkerState> restartAsync() throws InterruptedException {
        if (this.state != WorkerState.New) {
            this.stopSync();
        }
        return this.startAsync();
    }

    protected abstract boolean doStart();

    protected abstract boolean canDoWork();

    protected abstract Callable<Void> createWorkTask();

    protected abstract void doStop();

    protected final void error(String errorMessage, int escalationPriority) {
        this.errorCount += escalationPriority;
        this.onError(errorMessage, this.errorCount, this.errorEscalationThreshold);
    }

    protected void onError(String errorMessage, int errorCount, int errorThreshold) {
    }

    public String toString() {
        return this.name;
    }

    public void execute() {
        this.executionLock.lock();
        try {
            long startTs;
            block10: {
                Thread.interrupted();
                startTs = System.nanoTime();
                if (this.canDoWork()) {
                    long executionStartTs = System.nanoTime();
                    try {
                        try {
                            this.workTask.call();
                            this.errorCount = Math.max(0, this.errorCount - this.errorDecrement);
                            this.setExecutionResult(ExecutionResult.Success);
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                            this.error(exc.getMessage(), this.errorIncrement);
                            this.setExecutionResult(ExecutionResult.Error);
                            this.lastExecutionDuration = System.nanoTime() - executionStartTs;
                            ++this.executionCounter;
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        this.lastExecutionDuration = System.nanoTime() - executionStartTs;
                        ++this.executionCounter;
                        throw throwable;
                    }
                    this.lastExecutionDuration = System.nanoTime() - executionStartTs;
                    ++this.executionCounter;
                } else {
                    this.setExecutionResult(ExecutionResult.NoWork);
                }
            }
            long durationNano = System.nanoTime() - startTs;
            this.totalUtilization = this.totalUtilization.plusNanos(durationNano);
        }
        finally {
            this.executionLock.unlock();
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (AbstractWorker.this.rasterizedExecution) {
                    long now = Instant.now().toEpochMilli();
                    long offset = now % AbstractWorker.this.executionInterval;
                    long nextExecutionTs = now - offset + AbstractWorker.this.executionInterval;
                    AbstractWorker.this.setNextExecution(nextExecutionTs);
                    if (nextExecutionTs - now > 0L) {
                        this.sleep(nextExecutionTs - now);
                    }
                } else {
                    AbstractWorker.this.setNextExecution(Instant.now().toEpochMilli());
                }
                while (!AbstractWorker.this.pendingStop) {
                    long sleepMs;
                    if (AbstractWorker.this.pendingPause) {
                        AbstractWorker.this.setState(WorkerState.Paused);
                        while (AbstractWorker.this.pendingPause) {
                            this.sleep(10000L);
                        }
                        AbstractWorker.this.setState(WorkerState.Running);
                    }
                    AbstractWorker.this.lastExecution = AbstractWorker.this.nextExecution;
                    AbstractWorker.this.execute();
                    if (AbstractWorker.this.isErrorEscalation()) break;
                    long now = Instant.now().toEpochMilli();
                    if (AbstractWorker.this.rasterizedExecution) {
                        long offset = now % AbstractWorker.this.executionInterval;
                        sleepMs = AbstractWorker.this.executionInterval - offset;
                        long nextExecutionTs = now - offset + AbstractWorker.this.executionInterval;
                        AbstractWorker.this.setNextExecution(nextExecutionTs);
                    } else {
                        sleepMs = AbstractWorker.this.executionInterval;
                        AbstractWorker.this.setNextExecution(now + sleepMs);
                    }
                    if (sleepMs <= 0L) continue;
                    this.sleep(sleepMs);
                }
                AbstractWorker.this.pendingStop = false;
                AbstractWorker.this.pendingPause = false;
                AbstractWorker.this.doStop();
                Callable<Void> callable = AbstractWorker.this.workTask;
                synchronized (callable) {
                    AbstractWorker.this.setState(WorkerState.Stopped);
                }
                if (AbstractWorker.this.isErrorEscalation()) {
                    new Thread(() -> AbstractWorker.this.onErrorEscalation()).start();
                }
            }
            finally {
                AbstractWorker.this.workerThread = null;
            }
        }

        private void sleep(long millis) {
            try {
                Thread.sleep(Math.max(1L, millis));
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

