/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.worker;

import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.core.worker.ExecutionResult;
import de.elpro.ewms.core.worker.WorkerState;
import de.elpro.ui.model.UIModelElement;
import java.time.Duration;
import java.time.Instant;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BackgroundWorkerDescriptor
implements UIModelElement {
    public static final String DAO_NAMESPACE = "background_worker";
    private final StringProperty id = new SimpleStringProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<WorkerState> state = new SimpleObjectProperty();
    private final ObjectProperty<Instant> lastExecution = new SimpleObjectProperty();
    private final ObjectProperty<Long> lastExecutionDuration = new SimpleObjectProperty();
    private final ObjectProperty<ExecutionResult> lastExecutionResult = new SimpleObjectProperty();
    private final ObjectProperty<Instant> nextExecution = new SimpleObjectProperty();
    private final LongProperty executionCounter = new SimpleLongProperty();
    private final ObjectProperty<Duration> totalAge = new SimpleObjectProperty();
    private final ObjectProperty<Duration> totalUtilization = new SimpleObjectProperty();

    public BackgroundWorkerDescriptor() {
    }

    public BackgroundWorkerDescriptor(AbstractWorker worker) {
        this.setId(worker.getId());
        this.setName(worker.getName());
        this.setState(worker.getState());
        this.setLastExecution(Instant.ofEpochMilli(worker.getLastExecution()));
        this.setLastExecutionDuration(worker.getLastExecutionDuration());
        this.setLastExecutionResult(worker.getLastExecutionResult());
        this.setNextExecution(Instant.ofEpochMilli(worker.getNextExecution()));
        this.setExecutionCounter(worker.getExecutionCounter());
        this.setTotalAge(worker.getTotalAge());
        this.setTotalUtilization(worker.getTotalUtilization());
    }

    public StringProperty idProperty() {
        return this.id;
    }

    public String getId() {
        return (String)this.idProperty().get();
    }

    public void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public ObjectProperty<WorkerState> stateProperty() {
        return this.state;
    }

    public WorkerState getState() {
        return (WorkerState)((Object)this.stateProperty().get());
    }

    public void setState(WorkerState state) {
        this.stateProperty().set((Object)state);
    }

    public ObjectProperty<Instant> lastExecutionProperty() {
        return this.lastExecution;
    }

    public Instant getLastExecution() {
        return (Instant)this.lastExecutionProperty().get();
    }

    public void setLastExecution(Instant lastExecution) {
        this.lastExecutionProperty().set((Object)lastExecution);
    }

    public ObjectProperty<Long> lastExecutionDurationProperty() {
        return this.lastExecutionDuration;
    }

    public Long getLastExecutionDuration() {
        return (Long)this.lastExecutionDurationProperty().get();
    }

    public void setLastExecutionDuration(Long lastExecutionDuration) {
        this.lastExecutionDurationProperty().set((Object)lastExecutionDuration);
    }

    public ObjectProperty<ExecutionResult> lastExecutionResultProperty() {
        return this.lastExecutionResult;
    }

    public ExecutionResult getLastExecutionResult() {
        return (ExecutionResult)((Object)this.lastExecutionResultProperty().get());
    }

    public void setLastExecutionResult(ExecutionResult lastExecutionResult) {
        this.lastExecutionResultProperty().set((Object)lastExecutionResult);
    }

    public ObjectProperty<Instant> nextExecutionProperty() {
        return this.nextExecution;
    }

    public Instant getNextExecution() {
        return (Instant)this.nextExecutionProperty().get();
    }

    public void setNextExecution(Instant nextExecution) {
        this.nextExecutionProperty().set((Object)nextExecution);
    }

    public LongProperty executionCounterProperty() {
        return this.executionCounter;
    }

    public long getExecutionCounter() {
        return this.executionCounterProperty().get();
    }

    public void setExecutionCounter(long executionCounter) {
        this.executionCounterProperty().set(executionCounter);
    }

    public ObjectProperty<Duration> totalAgeProperty() {
        return this.totalAge;
    }

    public Duration getTotalAge() {
        return (Duration)this.totalAgeProperty().get();
    }

    public void setTotalAge(Duration totalAge) {
        this.totalAgeProperty().set((Object)totalAge);
    }

    public ObjectProperty<Duration> totalUtilizationProperty() {
        return this.totalUtilization;
    }

    public Duration getTotalUtilization() {
        return (Duration)this.totalUtilizationProperty().get();
    }

    public void setTotalUtilization(Duration totalUtilizarion) {
        this.totalUtilizationProperty().set((Object)totalUtilizarion);
    }

    public String toString() {
        return this.getName();
    }

    public String getIconUri() {
        if (this.getState() == null) {
            return null;
        }
        return this.getState().getIconUri();
    }
}

