/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.worker;

import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.core.worker.BackgroundWorkerGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class WorkersPool {
    private Map<String, BackgroundWorkerGroup> groups = new LinkedHashMap<String, BackgroundWorkerGroup>();
    private Map<String, Set<AbstractWorker>> groupWorkers = new HashMap<String, Set<AbstractWorker>>();
    private Map<String, AbstractWorker> workers = new HashMap<String, AbstractWorker>();

    public WorkersPool() {
        this.createGroup("default", "Default");
    }

    public void createGroup(String id, String name) {
        BackgroundWorkerGroup group = new BackgroundWorkerGroup(id, name);
        this.groups.put(id, group);
        this.groupWorkers.put(id, new LinkedHashSet());
    }

    public Collection<BackgroundWorkerGroup> getGroups() {
        return this.groups.values();
    }

    public BackgroundWorkerGroup getGroup(String id) {
        return this.groups.get(id);
    }

    public Set<AbstractWorker> getGroupWorkers(String groupId) {
        return Collections.unmodifiableSet(this.groupWorkers.get(groupId));
    }

    public void addWorker(AbstractWorker worker) {
        this.addWorker("default", worker);
    }

    public void addWorker(String groupId, AbstractWorker worker) {
        BackgroundWorkerGroup group = this.getGroup(groupId);
        if (group == null) {
            throw new IllegalArgumentException(String.format("Group ID '%s'not found", groupId));
        }
        this.groupWorkers.get(groupId).add(worker);
        this.workers.put(worker.getId(), worker);
    }

    public void removeWorker(String groupId, AbstractWorker worker) {
        BackgroundWorkerGroup group = this.getGroup(groupId);
        if (group == null) {
            throw new IllegalArgumentException(String.format("Group ID '%s'not found", groupId));
        }
        this.groupWorkers.get(groupId).remove(worker);
        this.workers.remove(worker.getId(), worker);
    }

    public AbstractWorker getWorker(String id) {
        return this.workers.get(id);
    }
}

