/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.clientconfig;

import de.elpro.ewms.server.model.AbstractConfiguration;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class Configuration
extends AbstractConfiguration {
    @Log
    @Inject
    private Logger logger;
    private Map<String, String> productUpdateURLs = new HashMap<String, String>();

    public Configuration() throws AbstractConfiguration.PreferenceDefinitionException {
        super("client-configurator.cfg", Configuration.class.getResource("/config/client-configurator.cfg"));
        Enumeration<?> names = this.prefNode.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("update_repo.")) continue;
            String productName = name.substring("update_repo.".length());
            String updateUrl = this.prefNode.getProperty(name);
            if (updateUrl == null || updateUrl.isBlank()) continue;
            this.productUpdateURLs.put(productName, updateUrl);
        }
    }

    public Set<String> getProducts() {
        return this.productUpdateURLs.keySet();
    }

    public String getProductUpdateURL(String productName) {
        return this.productUpdateURLs.get(productName);
    }
}

