/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus;

import com.invertor.modbus.Version;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Modbus {
    public static final int MAX_CONNECTION_TIMEOUT = 3000;
    public static final int MAX_RESPONSE_TIMEOUT = 1000;
    public static final int MAX_PDU_LENGTH = 254;
    public static final int MIN_PDU_LENGTH = 3;
    public static final int MAX_RTU_ADU_LENGTH = 256;
    public static final int MAX_REGISTER_VALUE = 65535;
    public static final int MIN_START_ADDRESS = 0;
    public static final int MAX_START_ADDRESS = 65535;
    public static final int MAX_READ_COIL_COUNT = 2000;
    public static final int MAX_WRITE_COIL_COUNT = 1968;
    public static final int MAX_READ_REGISTER_COUNT = 125;
    public static final int MAX_WRITE_REGISTER_COUNT = 123;
    public static final int MAX_FIFO_COUNT = 31;
    public static final int MIN_SERVER_ADDRESS = 1;
    public static final int MAX_SERVER_ADDRESS = 247;
    public static final int TCP_PORT = 502;
    public static final int PROTOCOL_ID = 0;
    public static final int ASCII_CODE_CR = 13;
    public static final int ASCII_CODE_LF = 10;
    public static final int ASCII_CODE_COLON = 58;
    public static final int COIL_VALUE_ON = 65280;
    public static final int COIL_VALUE_OFF = 0;
    public static final int TRANSACTION_ID_MAX_VALUE = 65535;
    private static final Logger log = Logger.getLogger(Modbus.class.getName());
    private static LogLevel logLevel = LogLevel.LEVEL_RELEASE;
    private static boolean autoIncrementTransactionId = false;
    private static int asciiMsgDelimiter = 10;

    static {
        Modbus.setLogLevel(logLevel);
        Modbus.log().setUseParentHandlers(false);
        Modbus.log().addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.out.println(String.valueOf(record.getLevel().getName()) + ": " + record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }

    private Modbus() {
    }

    public static String getVersion() {
        return Version.getVersion();
    }

    public static void setAsciiInputDelimiter(int asciiMsgDelimiter) {
        Modbus.asciiMsgDelimiter = asciiMsgDelimiter;
    }

    public static int getAsciiMsgDelimiter() {
        return asciiMsgDelimiter;
    }

    public static LogLevel getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(LogLevel level) {
        logLevel = level;
        log.setLevel(level.value());
        Handler[] handlerArray = log.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            handler.setLevel(level.value());
            ++n2;
        }
    }

    public static boolean isLoggingEnabled() {
        return Modbus.getLogLevel() != LogLevel.LEVEL_RELEASE;
    }

    public static Logger log() {
        return log;
    }

    public static boolean toCoil(int s) {
        return ((short)s & 0xFFFF) == 65280;
    }

    public static int fromCoil(boolean c) {
        return c ? 65280 : 0;
    }

    public static boolean checkServerAddress(int serverAddress) {
        if (serverAddress == 0) {
            Modbus.log().warning("Server address must be in range from 1 to 247");
            return true;
        }
        return serverAddress >= 1 && serverAddress <= 247;
    }

    private static boolean checkRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    private static boolean checkQuantity(int value, int max) {
        return Modbus.checkRange(value, 1, max);
    }

    private static boolean checkStartAddress(int value, int max) {
        return Modbus.checkRange(value, 0, max);
    }

    public static boolean checkReadRegisterCount(int value) {
        return Modbus.checkQuantity(value, 125);
    }

    public static boolean checkWriteRegisterCount(int value) {
        return Modbus.checkQuantity(value, 123);
    }

    public static boolean checkReadCoilCount(int value) {
        return Modbus.checkQuantity(value, 2000);
    }

    public static boolean checkWriteCoilCount(int value) {
        return Modbus.checkQuantity(value, 1968);
    }

    public static boolean checkStartAddress(int value) {
        return Modbus.checkStartAddress(value, 65535);
    }

    public static boolean checkEndAddress(int value) {
        return Modbus.checkStartAddress(value, 65536);
    }

    public static boolean checkRegisterValue(int value) {
        return Modbus.checkRange(value, 0, 65535);
    }

    public static boolean isAutoIncrementTransactionId() {
        return autoIncrementTransactionId;
    }

    public static void setAutoIncrementTransactionId(boolean autoIncrementTransactionId) {
        Modbus.autoIncrementTransactionId = autoIncrementTransactionId;
    }

    public static enum LogLevel {
        LEVEL_RELEASE(Level.SEVERE),
        LEVEL_WARNINGS(Level.WARNING),
        LEVEL_VERBOSE(Level.INFO),
        LEVEL_DEBUG(Level.ALL);

        private final Level value;

        private LogLevel(Level value) {
            this.value = value;
        }

        private Level value() {
            return this.value;
        }
    }
}

