/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.data.DataHolderBuilder;
import com.invertor.modbus.exception.ModbusIOException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ModbusSlave {
    private int serverAddress = 1;
    private DataHolder dataHolder = new DataHolder();
    private AtomicBoolean listening = new AtomicBoolean(false);
    private volatile int readTimeout = 1000;

    protected ModbusSlave() {
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected abstract void listenImpl() throws ModbusIOException;

    protected abstract void shutdownImpl() throws ModbusIOException;

    public final void listen() throws ModbusIOException {
        this.listenImpl();
        this.setListening(true);
    }

    public final void shutdown() throws ModbusIOException {
        this.shutdownImpl();
        this.setListening(false);
    }

    public boolean isListening() {
        return this.listening.get();
    }

    protected void setListening(boolean listening) {
        this.listening.set(listening);
    }

    public DataHolder getDataHolder() {
        return this.dataHolder;
    }

    public void setDataHolder(DataHolderBuilder builder) {
        this.setDataHolder(builder.build());
    }

    public void setDataHolder(DataHolder dataHolder) {
        this.dataHolder = dataHolder;
    }

    public int getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(int serverAddress) {
        if (Modbus.checkServerAddress(serverAddress)) {
            this.serverAddress = serverAddress;
        }
    }
}

