/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data;

import com.invertor.modbus.data.DataHolder;

public abstract class DataHolderBuilder {
    protected DataHolder dataHolder;

    protected DataHolderBuilder() {
        this.createNewDataHolder();
    }

    public DataHolder getDataHolder() {
        return this.dataHolder;
    }

    public final void createNewDataHolder() {
        this.dataHolder = new DataHolder();
    }

    public abstract void buildCoils();

    public abstract void buildDiscreteInputs();

    public abstract void buildHoldingRegisters();

    public abstract void buildInputRegisters();

    public abstract void buildSlaveId();

    public abstract void buildExceptionStatus();

    public abstract void buildFifoQueue();

    public abstract void readDeviceIdentificationInterface();

    public final DataHolder build() {
        this.createNewDataHolder();
        this.buildCoils();
        this.buildDiscreteInputs();
        this.buildHoldingRegisters();
        this.buildInputRegisters();
        this.buildSlaveId();
        this.buildExceptionStatus();
        this.buildFifoQueue();
        this.readDeviceIdentificationInterface();
        return this.getDataHolder();
    }
}

