/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.Coils;
import com.invertor.modbus.exception.IllegalDataAddressException;
import com.invertor.modbus.exception.IllegalDataValueException;
import java.util.Arrays;

public class SimpleCoils
implements Coils {
    private boolean[] coils = new boolean[0];

    public SimpleCoils(int size) {
        this.coils = new boolean[Modbus.checkEndAddress(size) ? size : 65535];
    }

    void setSize(int size) {
        if (this.coils.length != size) {
            this.coils = Arrays.copyOf(this.coils, size);
        }
    }

    @Override
    public void set(int offset, boolean coil) throws IllegalDataAddressException {
        this.checkAddress(offset);
        this.coils[offset] = coil;
    }

    @Override
    public void setRange(int offset, boolean[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, range.length);
        if (!Modbus.checkWriteCoilCount(range.length)) {
            throw new IllegalDataValueException();
        }
        System.arraycopy(range, 0, this.coils, offset, range.length);
    }

    @Override
    public int quantity() {
        return this.coils.length;
    }

    @Override
    public boolean get(int offset) throws IllegalDataAddressException {
        this.checkAddress(offset);
        return this.coils[offset];
    }

    @Override
    public boolean[] getRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, quantity);
        if (!Modbus.checkReadCoilCount(quantity)) {
            throw new IllegalDataValueException();
        }
        return Arrays.copyOfRange(this.coils, offset, offset + quantity);
    }

    private void checkRange(int offset, int quantity) throws IllegalDataAddressException {
        if (offset + quantity > this.quantity()) {
            throw new IllegalDataAddressException(offset);
        }
    }

    private void checkAddress(int offset) throws IllegalDataAddressException {
        if (!Modbus.checkStartAddress(offset)) {
            throw new IllegalDataAddressException(offset);
        }
    }
}

