/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.data.DataHolderBuilder;
import com.invertor.modbus.data.SimpleCoils;
import com.invertor.modbus.data.SimpleExceptionStatus;
import com.invertor.modbus.data.SimpleFifoQueue;
import com.invertor.modbus.data.SimpleHoldingRegisters;
import com.invertor.modbus.data.SimpleSlaveId;
import com.invertor.modbus.data.mei.ReadDeviceIdentificationInterface;
import com.invertor.modbus.exception.IllegalDataAddressException;

public class SimpleDataHolderBuilder
extends DataHolderBuilder {
    private final int coilCount;
    private final int discreteInputCount;
    private final int holdingRegisterCount;
    private final int inputRegisterCount;
    private final int slaveIdSize;

    public SimpleDataHolderBuilder(int size) {
        this.inputRegisterCount = this.slaveIdSize = size;
        this.holdingRegisterCount = this.slaveIdSize;
        this.discreteInputCount = this.slaveIdSize;
        this.coilCount = this.slaveIdSize;
    }

    public SimpleDataHolderBuilder(int slaveIdSize, int inputRegisterCount, int holdingRegisterCount, int discreteInputCount, int coilCount) {
        this.slaveIdSize = slaveIdSize;
        this.inputRegisterCount = inputRegisterCount;
        this.holdingRegisterCount = holdingRegisterCount;
        this.discreteInputCount = discreteInputCount;
        this.coilCount = coilCount;
    }

    @Override
    public DataHolder getDataHolder() {
        return this.dataHolder;
    }

    @Override
    public void buildCoils() {
        this.dataHolder.setCoils(new SimpleCoils(this.coilCount));
    }

    @Override
    public void buildDiscreteInputs() {
        this.dataHolder.setDiscreteInputs(new SimpleCoils(this.discreteInputCount));
    }

    @Override
    public void buildHoldingRegisters() {
        this.dataHolder.setHoldingRegisters(new SimpleHoldingRegisters(this.holdingRegisterCount));
    }

    @Override
    public void buildInputRegisters() {
        this.dataHolder.setInputRegisters(new SimpleHoldingRegisters(this.inputRegisterCount));
    }

    @Override
    public void buildSlaveId() {
        this.dataHolder.setSlaveId(new SimpleSlaveId(this.slaveIdSize));
    }

    @Override
    public void buildExceptionStatus() {
        this.dataHolder.setExceptionStatus(new SimpleExceptionStatus(0));
    }

    @Override
    public void buildFifoQueue() {
        try {
            this.dataHolder.addFifoQueue(new SimpleFifoQueue(), 0);
        }
        catch (IllegalDataAddressException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readDeviceIdentificationInterface() {
        this.dataHolder.setReadDeviceIdentificationInterface(new ReadDeviceIdentificationInterface());
    }
}

