/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.HoldingRegisters;
import com.invertor.modbus.exception.IllegalDataAddressException;
import com.invertor.modbus.exception.IllegalDataValueException;
import java.util.Arrays;

public class SimpleHoldingRegisters
implements HoldingRegisters {
    private int[] registers = new int[0];

    public SimpleHoldingRegisters(int size) {
        this.registers = new int[Modbus.checkEndAddress(size) ? size : 65535];
    }

    @Override
    public void set(int offset, int value) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkAddress(offset);
        this.checkValue(value);
        this.registers[offset] = value;
    }

    @Override
    public void setRange(int offset, int[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, range.length);
        if (!Modbus.checkWriteRegisterCount(range.length)) {
            throw new IllegalDataAddressException(offset);
        }
        System.arraycopy(range, 0, this.registers, offset, range.length);
    }

    @Override
    public int quantity() {
        return this.registers.length;
    }

    @Override
    public int get(int offset) throws IllegalDataAddressException {
        this.checkAddress(offset);
        return this.registers[offset];
    }

    @Override
    public int[] getRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, quantity);
        if (!Modbus.checkReadRegisterCount(quantity)) {
            throw new IllegalDataAddressException(offset);
        }
        return Arrays.copyOfRange(this.registers, offset, offset + quantity);
    }

    private void checkRange(int offset, int quantity) throws IllegalDataAddressException {
        if (offset + quantity > this.quantity()) {
            throw new IllegalDataAddressException(offset);
        }
    }

    private void checkAddress(int offset) throws IllegalDataAddressException {
        if (offset > this.quantity() - 1) {
            throw new IllegalDataAddressException(offset);
        }
    }

    private void checkValue(int value) throws IllegalDataValueException {
        if (!Modbus.checkRegisterValue(value)) {
            throw new IllegalDataValueException();
        }
    }
}

