/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data.comm;

import com.invertor.modbus.data.comm.ModbusCommEventEnterListenOnlyMode;
import com.invertor.modbus.data.comm.ModbusCommEventInitiatedCommunicationRestart;
import com.invertor.modbus.data.comm.ModbusCommEventReceive;
import com.invertor.modbus.data.comm.ModbusCommEventSend;

public abstract class ModbusCommEvent {
    private final Type type;
    private int event = 0;

    public ModbusCommEvent(Type type, int event) {
        this.type = type;
        this.event = type.getCode() | event;
    }

    public static ModbusCommEvent getEvent(int event) {
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            if ((t.getCode() & event) == t.getCode()) {
                switch (t) {
                    case SEND: {
                        return new ModbusCommEventSend(event);
                    }
                    case RECEIVE: {
                        return new ModbusCommEventReceive(event);
                    }
                    case INITIATED_COMMUNICATION_RESTART: {
                        return new ModbusCommEventInitiatedCommunicationRestart(event);
                    }
                    case ENTER_LISTEN_ONLY_MODE: {
                        return new ModbusCommEventEnterListenOnlyMode(event);
                    }
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    public Type getType() {
        return this.type;
    }

    protected boolean isBitsSet(int bits) {
        return (this.event & bits) == bits;
    }

    public int getEvent() {
        return this.event;
    }

    public static enum Type {
        SEND(128),
        RECEIVE(64),
        INITIATED_COMMUNICATION_RESTART(0),
        ENTER_LISTEN_ONLY_MODE(16);

        private final int code;

        private Type(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

