/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.master;

import com.invertor.modbus.ModbusMaster;
import com.invertor.modbus.data.CommStatus;
import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.response.DiagnosticsResponse;
import com.invertor.modbus.msg.response.GetCommEventCounterResponse;
import com.invertor.modbus.msg.response.GetCommEventLogResponse;
import com.invertor.modbus.msg.response.ReadExceptionStatusResponse;
import com.invertor.modbus.msg.response.ReportSlaveIdResponse;

public abstract class ModbusMasterSerial
extends ModbusMaster {
    private final CommStatus commStatus = new CommStatus();

    @Override
    public final synchronized int readExceptionStatus(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReadExceptionStatus(serverAddress);
        ReadExceptionStatusResponse response = (ReadExceptionStatusResponse)this.processRequest(request);
        return response.getExceptionStatus();
    }

    @Override
    public final synchronized byte[] reportSlaveId(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReportSlaveId(serverAddress);
        ReportSlaveIdResponse response = (ReportSlaveIdResponse)this.processRequest(request);
        return response.getSlaveId();
    }

    @Override
    public final synchronized CommStatus getCommEventCounter(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createGetCommEventCounter(serverAddress);
        GetCommEventCounterResponse response = (GetCommEventCounterResponse)this.processRequest(request);
        this.commStatus.setCommStatus(response.getStatus());
        this.commStatus.setEventCount(response.getEventCount());
        return this.commStatus;
    }

    @Override
    public final synchronized CommStatus getCommEventLog(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createGetCommEventLog(serverAddress);
        GetCommEventLogResponse response = (GetCommEventLogResponse)this.processRequest(request);
        this.commStatus.setCommStatus(response.getStatus());
        this.commStatus.setEventCount(response.getEventCount());
        this.commStatus.setBusMessageCount(response.getMessageCount());
        this.commStatus.setEventQueue(response.getEventQueue());
        return this.commStatus;
    }

    @Override
    public final synchronized void diagnosticsReturnQueryData(int serverAddress, int queryData) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(this.requestFactory.createReturnQueryData(serverAddress, queryData));
    }

    @Override
    public final synchronized void diagnosticsRestartCommunicationsOption(int serverAddress, boolean clearLog) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(this.requestFactory.createRestartCommunicationsOption(serverAddress, clearLog));
    }

    @Override
    public final synchronized int diagnosticsReturnDiagnosticRegister(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReturnDiagnosticRegister(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final synchronized void diagnosticsChangeAsciiInputDelimiter(int serverAddress, int delimiter) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(this.requestFactory.createChangeAsciiInputDelimiter(serverAddress, delimiter));
    }

    @Override
    public final synchronized void diagnosticsForceListenOnlyMode(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(this.requestFactory.createForceListenOnlyMode(serverAddress));
    }

    @Override
    public final synchronized void diagnosticsClearCountersAndDiagnosticRegister(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(this.requestFactory.createClearCountersAndDiagnosticRegister(serverAddress));
    }

    @Override
    public final synchronized int diagnosticsReturnBusMessageCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReturnBusMessageCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final synchronized int diagnosticsReturnBusCommunicationErrorCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReturnBusCommunicationErrorCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final synchronized int diagnosticsReturnBusExceptionErrorCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReturnBusExceptionErrorCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final synchronized int diagnosticsReturnSlaveMessageCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReturnSlaveMessageCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final synchronized int diagnosticsReturnSlaveNoResponseCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReturnSlaveNoResponseCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final synchronized int diagnosticsReturnSlaveNAKCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReturnSlaveNAKCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final synchronized int diagnosticsReturnSlaveBusyCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReturnSlaveBusyCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final synchronized int diagnosticsReturnBusCharacterOverrunCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReturnBusCharacterOverrunCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final synchronized void diagnosticsClearOverrunCounterAndFlag(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(this.requestFactory.createClearOverrunCounterAndFlag(serverAddress));
    }
}

