/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.master;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.ModbusMaster;
import com.invertor.modbus.data.CommStatus;
import com.invertor.modbus.exception.IllegalFunctionException;
import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.net.ModbusConnectionFactory;
import com.invertor.modbus.tcp.TcpParameters;
import com.invertor.modbus.utils.ModbusFunctionCode;

public final class ModbusMasterTCP
extends ModbusMaster {
    private final boolean keepAlive;
    private final ModbusConnection conn;

    public ModbusMasterTCP(TcpParameters parameters) {
        this.conn = ModbusConnectionFactory.getTcpMaster(parameters);
        this.keepAlive = parameters.isKeepAlive();
        try {
            if (this.isKeepAlive()) {
                this.connect();
            }
        }
        catch (ModbusIOException modbusIOException) {
            Modbus.log().warning("keepAlive is set, connection failed at creation time.");
        }
    }

    private int nextTransactionId() {
        int nextId = this.getTransactionId() + 1;
        return nextId > 65535 ? 0 : nextId;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    protected void sendRequest(ModbusMessage msg) throws ModbusIOException {
        if (!this.isKeepAlive()) {
            this.connect();
        }
        try {
            if (Modbus.isAutoIncrementTransactionId()) {
                this.setTransactionId(this.nextTransactionId());
            }
            msg.setTransactionId(this.getTransactionId());
            super.sendRequest(msg);
        }
        catch (ModbusIOException e) {
            if (this.isKeepAlive()) {
                this.connect();
                super.sendRequest(msg);
            }
            throw e;
        }
    }

    @Override
    protected ModbusMessage readResponse() throws ModbusNumberException, ModbusIOException, ModbusProtocolException {
        ModbusMessage msg = super.readResponse();
        if (!this.isKeepAlive()) {
            this.disconnect();
        }
        return msg;
    }

    @Override
    protected ModbusConnection getConnection() {
        return this.conn;
    }

    @Override
    public int readExceptionStatus(int serverAddress) throws ModbusNumberException, ModbusIOException, ModbusProtocolException {
        throw new IllegalFunctionException(ModbusFunctionCode.READ_EXCEPTION_STATUS.toInt());
    }

    @Override
    public byte[] reportSlaveId(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        throw new IllegalFunctionException(ModbusFunctionCode.REPORT_SLAVE_ID.toInt());
    }

    @Override
    public CommStatus getCommEventCounter(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        throw new IllegalFunctionException(ModbusFunctionCode.GET_COMM_EVENT_COUNTER.toInt());
    }

    @Override
    public CommStatus getCommEventLog(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        throw new IllegalFunctionException(ModbusFunctionCode.GET_COMM_EVENT_LOG.toInt());
    }

    @Override
    public void diagnosticsReturnQueryData(int serverAddress, int queryData) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public void diagnosticsRestartCommunicationsOption(int serverAddress, boolean clearLog) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public int diagnosticsReturnDiagnosticRegister(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public void diagnosticsChangeAsciiInputDelimiter(int serverAddress, int delimiter) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public void diagnosticsForceListenOnlyMode(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public void diagnosticsClearCountersAndDiagnosticRegister(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public int diagnosticsReturnBusMessageCount(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public int diagnosticsReturnBusCommunicationErrorCount(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public int diagnosticsReturnBusExceptionErrorCount(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public int diagnosticsReturnSlaveMessageCount(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public int diagnosticsReturnSlaveNoResponseCount(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public int diagnosticsReturnSlaveNAKCount(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public int diagnosticsReturnSlaveBusyCount(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public int diagnosticsReturnBusCharacterOverrunCount(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }

    @Override
    public void diagnosticsClearOverrunCounterAndFlag(int serverAddress) throws ModbusNumberException, IllegalFunctionException {
        throw new IllegalFunctionException(ModbusFunctionCode.DIAGNOSTICS.toInt());
    }
}

