/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.ModbusMessageFactory;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.DiagnosticsResponse;
import com.invertor.modbus.msg.response.EncapsulatedInterfaceTransportResponse;
import com.invertor.modbus.msg.response.GetCommEventCounterResponse;
import com.invertor.modbus.msg.response.GetCommEventLogResponse;
import com.invertor.modbus.msg.response.MaskWriteRegisterResponse;
import com.invertor.modbus.msg.response.ReadCoilsResponse;
import com.invertor.modbus.msg.response.ReadDiscreteInputsResponse;
import com.invertor.modbus.msg.response.ReadExceptionStatusResponse;
import com.invertor.modbus.msg.response.ReadFifoQueueResponse;
import com.invertor.modbus.msg.response.ReadFileRecordResponse;
import com.invertor.modbus.msg.response.ReadHoldingRegistersResponse;
import com.invertor.modbus.msg.response.ReadInputRegistersResponse;
import com.invertor.modbus.msg.response.ReadWriteMultipleRegistersResponse;
import com.invertor.modbus.msg.response.ReportSlaveIdResponse;
import com.invertor.modbus.msg.response.WriteFileRecordResponse;
import com.invertor.modbus.msg.response.WriteMultipleCoilsResponse;
import com.invertor.modbus.msg.response.WriteMultipleRegistersResponse;
import com.invertor.modbus.msg.response.WriteSingleCoilResponse;
import com.invertor.modbus.msg.response.WriteSingleRegisterResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class ModbusResponseFactory
implements ModbusMessageFactory {
    private ModbusResponseFactory() {
    }

    public static ModbusResponseFactory getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public ModbusMessage createMessage(ModbusInputStream fifo) throws ModbusNumberException, ModbusIOException {
        int functionCode;
        int serverAddress;
        try {
            serverAddress = fifo.read();
            functionCode = fifo.read();
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
        ModbusResponse msg = switch (ModbusFunctionCode.get(functionCode)) {
            case ModbusFunctionCode.READ_COILS -> new ReadCoilsResponse(serverAddress);
            case ModbusFunctionCode.READ_DISCRETE_INPUTS -> new ReadDiscreteInputsResponse(serverAddress);
            case ModbusFunctionCode.READ_HOLDING_REGISTERS -> new ReadHoldingRegistersResponse(serverAddress);
            case ModbusFunctionCode.READ_INPUT_REGISTERS -> new ReadInputRegistersResponse(serverAddress);
            case ModbusFunctionCode.WRITE_SINGLE_COIL -> new WriteSingleCoilResponse(serverAddress);
            case ModbusFunctionCode.WRITE_SINGLE_REGISTER -> new WriteSingleRegisterResponse(serverAddress);
            case ModbusFunctionCode.WRITE_MULTIPLE_COILS -> new WriteMultipleCoilsResponse(serverAddress);
            case ModbusFunctionCode.WRITE_MULTIPLE_REGISTERS -> new WriteMultipleRegistersResponse(serverAddress);
            case ModbusFunctionCode.MASK_WRITE_REGISTER -> new MaskWriteRegisterResponse(serverAddress);
            case ModbusFunctionCode.READ_WRITE_MULTIPLE_REGISTERS -> new ReadWriteMultipleRegistersResponse(serverAddress);
            case ModbusFunctionCode.READ_FIFO_QUEUE -> new ReadFifoQueueResponse(serverAddress);
            case ModbusFunctionCode.READ_FILE_RECORD -> new ReadFileRecordResponse(serverAddress);
            case ModbusFunctionCode.WRITE_FILE_RECORD -> new WriteFileRecordResponse(serverAddress);
            case ModbusFunctionCode.READ_EXCEPTION_STATUS -> new ReadExceptionStatusResponse(serverAddress);
            case ModbusFunctionCode.REPORT_SLAVE_ID -> new ReportSlaveIdResponse(serverAddress);
            case ModbusFunctionCode.GET_COMM_EVENT_COUNTER -> new GetCommEventCounterResponse(serverAddress);
            case ModbusFunctionCode.GET_COMM_EVENT_LOG -> new GetCommEventLogResponse(serverAddress);
            case ModbusFunctionCode.DIAGNOSTICS -> new DiagnosticsResponse(serverAddress);
            case ModbusFunctionCode.ENCAPSULATED_INTERFACE_TRANSPORT -> new EncapsulatedInterfaceTransportResponse(serverAddress);
            default -> throw new ModbusNumberException("Unknown function code", functionCode);
        };
        if (ModbusFunctionCode.isException(functionCode)) {
            msg.setException();
        }
        msg.read(fifo);
        return msg;
    }

    private static class SingletonHolder {
        private static final ModbusResponseFactory instance = new ModbusResponseFactory();

        private SingletonHolder() {
        }
    }
}

