/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class AbstractDataRequest
extends ModbusRequest {
    private int startAddress;

    protected AbstractDataRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    protected AbstractDataRequest(int serverAddress, int startAddress) throws ModbusNumberException {
        super(serverAddress);
        if (!Modbus.checkStartAddress(startAddress)) {
            throw new ModbusNumberException("Error in start address", startAddress);
        }
        this.setStartAddress((short)startAddress & 0xFFFF);
    }

    protected abstract void writeData(ModbusOutputStream var1) throws IOException;

    protected abstract void readData(ModbusInputStream var1) throws IOException, ModbusNumberException;

    @Override
    public final void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        this.setStartAddress(fifo.readShortBE());
        this.readData(fifo);
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getStartAddress());
        this.writeData(fifo);
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(int startAddress) {
        this.startAddress = startAddress;
    }

    @Override
    public final int requestSize() {
        return 2 + this.dataSize();
    }

    protected abstract int dataSize();
}

