/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base;

import com.invertor.modbus.exception.IllegalDataValueException;
import java.util.Arrays;

public class ModbusFileRecord {
    public static final int REF_TYPE = 6;
    private final int number;
    private final int file;
    private int length = 0;
    private int[] registers;

    public ModbusFileRecord(int fileNumber, int recordNumber, int registerCount) {
        this.file = fileNumber;
        this.number = recordNumber;
        this.length = registerCount;
    }

    public ModbusFileRecord(int file, int number, int[] buffer) {
        this.file = file;
        this.number = number;
        this.setRegisters(buffer);
    }

    public int[] getRegisters() {
        return Arrays.copyOf(this.registers, this.registers.length);
    }

    protected void setRegisters(int[] registers) {
        this.registers = Arrays.copyOf(registers, registers.length);
        this.length = registers.length;
    }

    public void writeRegisters(int[] registers) throws IllegalDataValueException {
        if (registers.length > this.getRegisters().length) {
            throw new IllegalDataValueException();
        }
        this.length = registers.length;
    }

    public int getFileNumber() {
        return this.file;
    }

    public int getRecordNumber() {
        return this.number;
    }

    public int getRecordLength() {
        return this.length;
    }
}

