/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class ModbusMessage {
    private final int serverAddress;
    private int protocolId = 0;
    private int transactionId = 0;

    ModbusMessage(int serverAddress) throws ModbusNumberException {
        if (!Modbus.checkServerAddress(serverAddress)) {
            throw new ModbusNumberException("Error in slave id", serverAddress);
        }
        this.serverAddress = serverAddress;
    }

    public final void write(ModbusOutputStream fifo) throws ModbusIOException {
        try {
            fifo.write(this.getServerAddress());
            this.writePDU(fifo);
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
    }

    public final void read(ModbusInputStream fifo) throws ModbusNumberException, ModbusIOException {
        try {
            this.readPDU(fifo);
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
    }

    public abstract void readPDU(ModbusInputStream var1) throws ModbusNumberException, IOException;

    protected abstract void writePDU(ModbusOutputStream var1) throws IOException;

    public abstract int getFunction();

    public int size() {
        return 1 + this.pduSize();
    }

    protected abstract int pduSize();

    public int getServerAddress() {
        return this.serverAddress;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }
}

