/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusExceptionCode;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public abstract class ModbusResponse
extends ModbusMessage {
    private volatile ModbusExceptionCode modbusExceptionCode = ModbusExceptionCode.NO_EXCEPTION;

    protected ModbusResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public final boolean isException() {
        return this.modbusExceptionCode != ModbusExceptionCode.NO_EXCEPTION;
    }

    public final void setException() {
        this.modbusExceptionCode = ModbusExceptionCode.UNKNOWN_EXCEPTION;
    }

    @Override
    protected final void writePDU(ModbusOutputStream fifo) throws IOException {
        if (this.isException()) {
            fifo.write(ModbusFunctionCode.getExceptionValue(this.getFunction()));
            fifo.write(this.getModbusExceptionCode().getValue());
        } else {
            fifo.write(this.getFunction());
            this.writeResponse(fifo);
        }
    }

    @Override
    public final void readPDU(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        if (this.isException()) {
            this.setModbusExceptionCode(fifo.read());
        } else {
            this.readResponse(fifo);
        }
    }

    protected abstract void readResponse(ModbusInputStream var1) throws IOException, ModbusNumberException;

    protected abstract void writeResponse(ModbusOutputStream var1) throws IOException;

    public final ModbusExceptionCode getModbusExceptionCode() {
        return this.modbusExceptionCode;
    }

    public final void setModbusExceptionCode(int code) {
        this.modbusExceptionCode = ModbusExceptionCode.get(code);
    }

    @Override
    protected final int pduSize() {
        return 1 + this.responseSize();
    }

    protected abstract int responseSize();
}

