/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.GetCommEventCounterResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class GetCommEventCounterRequest
extends ModbusRequest {
    public GetCommEventCounterRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
    }

    @Override
    public int requestSize() {
        return 0;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        GetCommEventCounterResponse response = new GetCommEventCounterResponse(this.getServerAddress());
        response.setEventCount(dataHolder.getCommStatus().getEventCount());
        response.setStatus(dataHolder.getCommStatus().getCommStatus());
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        return true;
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.GET_COMM_EVENT_COUNTER.toInt();
    }
}

