/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusFileRecord;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.ReadFileRecordResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public final class ReadFileRecordRequest
extends ModbusRequest {
    public static final int READ__SUB_REQ_LENGTH = 7;
    private ModbusFileRecord[] records = null;

    public ReadFileRecordRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public ReadFileRecordRequest(int serverAddress, ModbusFileRecord[] records) throws ModbusNumberException {
        super(serverAddress);
        this.records = Arrays.copyOf(records, records.length);
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.write(7 * this.records.length);
        ModbusFileRecord[] modbusFileRecordArray = this.records;
        int n = this.records.length;
        int n2 = 0;
        while (n2 < n) {
            ModbusFileRecord record = modbusFileRecordArray[n2];
            fifo.write(6);
            fifo.writeShortBE(record.getFileNumber());
            fifo.writeShortBE(record.getRecordNumber());
            fifo.writeShortBE(record.getRecordLength());
            ++n2;
        }
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        LinkedList<ModbusFileRecord> records = new LinkedList<ModbusFileRecord>();
        int byteCount = fifo.read();
        if (byteCount > 252) {
            throw new ModbusNumberException("Byte count greater than max allowable");
        }
        int read = 0;
        while (read < byteCount) {
            if (fifo.read() != 6) {
                throw new ModbusNumberException("Reference type mismatch.");
            }
            int file_number = fifo.readShortBE();
            int record_number = fifo.readShortBE();
            int record_length = fifo.readShortBE();
            read += 7;
            records.add(new ModbusFileRecord(file_number, record_number, record_length));
        }
        this.records = records.toArray(new ModbusFileRecord[records.size()]);
    }

    @Override
    public int requestSize() {
        return 1 + 7 * this.records.length;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadFileRecordResponse response = new ReadFileRecordResponse(this.getServerAddress());
        try {
            ModbusFileRecord[] modbusFileRecordArray = this.records;
            int n = this.records.length;
            int n2 = 0;
            while (n2 < n) {
                ModbusFileRecord r = modbusFileRecordArray[n2];
                r.writeRegisters(dataHolder.readFileRecord(r.getFileNumber(), r.getRecordNumber(), r.getRecordLength()));
                ++n2;
            }
            response.setFileRecords(this.records);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    protected boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadFileRecordResponse)) {
            return false;
        }
        ModbusFileRecord[] respRecords = ((ReadFileRecordResponse)response).getFileRecords();
        if (this.records.length != respRecords.length) {
            return false;
        }
        int i = 0;
        while (i < this.records.length) {
            if (respRecords[i].getRecordLength() != this.records[i].getRecordLength()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_FILE_RECORD.toInt();
    }
}

