/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.request.ReadHoldingRegistersRequest;
import com.invertor.modbus.msg.response.ReadInputRegistersResponse;
import com.invertor.modbus.utils.ModbusFunctionCode;

public final class ReadInputRegistersRequest
extends ReadHoldingRegistersRequest {
    public ReadInputRegistersRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public ReadInputRegistersRequest(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        super(serverAddress, startAddress, quantity);
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadInputRegistersResponse response = new ReadInputRegistersResponse(this.getServerAddress());
        try {
            int[] range = dataHolder.readInputRegisterRange(this.getStartAddress(), this.getQuantity());
            response.setBuffer(range);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadInputRegistersResponse)) {
            return false;
        }
        ReadInputRegistersResponse r = (ReadInputRegistersResponse)response;
        return r.getByteCount() == this.getQuantity() * 2;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_INPUT_REGISTERS.toInt();
    }
}

