/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.request.ReadHoldingRegistersRequest;
import com.invertor.modbus.msg.request.WriteMultipleRegistersRequest;
import com.invertor.modbus.msg.response.ReadWriteMultipleRegistersResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class ReadWriteMultipleRegistersRequest
extends ModbusRequest {
    private final ReadHoldingRegistersRequest reader;
    private final WriteMultipleRegistersRequest writer;

    public ReadWriteMultipleRegistersRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
        this.reader = new ReadHoldingRegistersRequest(serverAddress);
        this.writer = new WriteMultipleRegistersRequest(serverAddress);
    }

    public ReadWriteMultipleRegistersRequest(int serverAddress, int readAddress, int readQuantity, int writeAddress, int[] buffer) throws ModbusNumberException {
        super(serverAddress);
        this.reader = new ReadHoldingRegistersRequest(serverAddress, readAddress, readQuantity);
        this.writer = new WriteMultipleRegistersRequest(serverAddress, writeAddress, buffer);
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        this.reader.writeRequest(fifo);
        this.writer.writeRequest(fifo);
    }

    @Override
    public int requestSize() {
        return this.reader.requestSize() + this.writer.requestSize();
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadWriteMultipleRegistersResponse response = new ReadWriteMultipleRegistersResponse(this.getServerAddress());
        try {
            dataHolder.writeHoldingRegisterRange(this.writer.getStartAddress(), this.writer.getRegisters());
            int[] range = dataHolder.readHoldingRegisterRange(this.reader.getStartAddress(), this.reader.getQuantity());
            response.setBuffer(range);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadWriteMultipleRegistersResponse)) {
            return false;
        }
        ReadWriteMultipleRegistersResponse r = (ReadWriteMultipleRegistersResponse)response;
        return r.getByteCount() == this.reader.getQuantity() * 2;
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        this.reader.readPDU(fifo);
        this.writer.readPDU(fifo);
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_WRITE_MULTIPLE_REGISTERS.toInt();
    }
}

