/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusFileRecord;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.WriteFileRecordResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DataUtils;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class WriteFileRecordRequest
extends ModbusRequest {
    public static final int READ_SUB_REQ_LENGTH = 7;
    private ModbusFileRecord record = null;

    public WriteFileRecordRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public WriteFileRecordRequest(int serverAddress, ModbusFileRecord record) throws ModbusNumberException {
        super(serverAddress);
        this.record = record;
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.write(7 + this.record.getRecordLength() * 2);
        fifo.write(6);
        fifo.writeShortBE(this.record.getFileNumber());
        fifo.writeShortBE(this.record.getRecordNumber());
        fifo.writeShortBE(this.record.getRecordLength());
        fifo.write(DataUtils.toByteArray(this.record.getRegisters()));
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        int byteCount = fifo.read();
        if (byteCount > 252) {
            throw new ModbusNumberException("Byte count greater than max allowable");
        }
        if (fifo.read() != 6) {
            throw new ModbusNumberException("Reference type mismatch.");
        }
        int file_number = fifo.readShortBE();
        int record_number = fifo.readShortBE();
        int record_length = fifo.readShortBE();
        byte[] buffer = new byte[record_length * 2];
        if (fifo.read(buffer) != buffer.length) {
            throw new ModbusNumberException(String.valueOf(record_length) + " bytes expected, but not received.");
        }
        this.record = new ModbusFileRecord(file_number, record_number, DataUtils.toIntArray(buffer));
    }

    @Override
    public int requestSize() {
        return 1 + 7 * this.record.getRecordLength() * 2;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteFileRecordResponse response = new WriteFileRecordResponse(this.getServerAddress(), this.record);
        try {
            dataHolder.writeFileRecord(response.getFileRecord());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    protected boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteFileRecordResponse)) {
            return false;
        }
        ModbusFileRecord respRecord = ((WriteFileRecordResponse)response).getFileRecord();
        return respRecord.getFileNumber() == this.record.getFileNumber() && respRecord.getRecordNumber() == this.record.getRecordNumber() && respRecord.getRecordLength() == this.record.getRecordLength();
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_FILE_RECORD.toInt();
    }
}

