/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.AbstractWriteMultipleRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.WriteMultipleCoilsResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.utils.DataUtils;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class WriteMultipleCoilsRequest
extends AbstractWriteMultipleRequest {
    private boolean[] coils = null;

    public WriteMultipleCoilsRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public WriteMultipleCoilsRequest(int serverAddress, int startAddress, boolean[] coils) throws ModbusNumberException {
        super(serverAddress, startAddress, DataUtils.toByteArray(coils), coils.length);
        this.setCoils(coils);
    }

    @Override
    protected boolean checkAddressRange(int startAddress, int quantity) {
        return Modbus.checkWriteCoilCount(quantity) && Modbus.checkStartAddress(startAddress) && Modbus.checkEndAddress(startAddress + quantity);
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteMultipleCoilsResponse response = new WriteMultipleCoilsResponse(this.getServerAddress(), this.getStartAddress(), this.getQuantity());
        try {
            dataHolder.writeCoilRange(this.getStartAddress(), this.getCoils());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteMultipleCoilsResponse)) {
            return false;
        }
        WriteMultipleCoilsResponse r = (WriteMultipleCoilsResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getValue() == this.getQuantity();
    }

    @Override
    public void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        super.readData(fifo);
        if ((int)Math.ceil((double)this.getQuantity() / 8.0) != this.getByteCount()) {
            throw new ModbusNumberException("Byte count not matches quantity/8", this.getByteCount());
        }
        if (!this.checkAddressRange(this.getStartAddress(), this.getQuantity())) {
            throw new ModbusNumberException("Coil count greater than max coil count", this.getQuantity());
        }
        this.setCoils(DataUtils.toBitsArray(this.getValues(), this.getQuantity()));
    }

    private boolean[] getCoils() {
        return this.coils;
    }

    private void setCoils(boolean[] coils) {
        this.coils = coils;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_MULTIPLE_COILS.toInt();
    }
}

