/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.data.comm.ModbusCommEvent;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class GetCommEventLogResponse
extends ModbusResponse {
    public static final int EVENTS_OFFSET = 6;
    private int status;
    private int eventCount;
    private int messageCount;
    private List<ModbusCommEvent> events = new LinkedList<ModbusCommEvent>();

    public GetCommEventLogResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    @Override
    protected void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        int byteCount = fifo.read();
        if (byteCount < 6 || byteCount > 252) {
            throw new ModbusNumberException("Illegal byte count", byteCount);
        }
        this.setStatus(fifo.readShortBE());
        this.setEventCount(fifo.readShortBE());
        this.setMessageCount(fifo.readShortBE());
        int eventsCount = byteCount - 6;
        if (eventsCount > 0) {
            int i = 0;
            while (i < eventsCount) {
                this.events.add(ModbusCommEvent.getEvent(fifo.read()));
                ++i;
            }
        }
    }

    @Override
    protected void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.write(6 + this.events.size());
        fifo.writeShortBE(this.getStatus());
        fifo.writeShortBE(this.getEventCount());
        fifo.writeShortBE(this.getMessageCount());
        for (ModbusCommEvent event : this.getEventQueue()) {
            fifo.write(event.getEvent());
        }
    }

    @Override
    protected int responseSize() {
        return 6 + this.events.size();
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.GET_COMM_EVENT_LOG.toInt();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    public List<ModbusCommEvent> getEventQueue() {
        return this.events;
    }

    public void setEvents(List<ModbusCommEvent> events) {
        this.events = events;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }
}

