/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.AbstractReadResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DataUtils;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class ReadCoilsResponse
extends AbstractReadResponse {
    private byte[] buffer = null;

    public ReadCoilsResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public static int calcByteCount(boolean[] coils) {
        return ReadCoilsResponse.calcByteCount(coils.length);
    }

    public static int calcByteCount(int coilCount) {
        return (int)Math.ceil((double)coilCount / 8.0);
    }

    public final boolean[] getCoils() {
        return this.buffer != null ? DataUtils.toBitsArray(this.buffer, this.buffer.length * 8) : new boolean[]{};
    }

    public final void setCoils(boolean[] coils) throws ModbusNumberException {
        this.buffer = DataUtils.toByteArray(coils);
        this.setByteCount(ReadCoilsResponse.calcByteCount(coils));
    }

    @Override
    protected final void readData(ModbusInputStream fifo) throws IOException {
        this.buffer = new byte[this.getByteCount()];
        int size = fifo.read(this.buffer);
        if (size < this.buffer.length) {
            Modbus.log().warning(String.valueOf(this.buffer.length) + " bytes expected, but " + size + " received.");
        }
    }

    @Override
    protected final void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.buffer);
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_COILS.toInt();
    }
}

