/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class ReadExceptionStatusResponse
extends ModbusResponse {
    private int exceptionStatus = 0;

    public ReadExceptionStatusResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public int getExceptionStatus() {
        return this.exceptionStatus;
    }

    public void setExceptionStatus(int exceptionStatus) {
        this.exceptionStatus = (byte)exceptionStatus & 0xFF;
    }

    @Override
    protected void readResponse(ModbusInputStream fifo) throws IOException {
        this.setExceptionStatus(fifo.read());
    }

    @Override
    protected void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.getExceptionStatus());
    }

    @Override
    protected int responseSize() {
        return 1;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_EXCEPTION_STATUS.toInt();
    }
}

