/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.AbstractReadResponse;
import com.invertor.modbus.msg.base.ModbusFileRecord;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DataUtils;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public final class ReadFileRecordResponse
extends AbstractReadResponse {
    public static final int READ_RESP_SUB_REQ_LENGTH = 2;
    private ModbusFileRecord[] fileRecords = null;

    public ReadFileRecordResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    @Override
    protected void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        LinkedList<ModbusFileRecord> records = new LinkedList<ModbusFileRecord>();
        int response_byte_count = this.getByteCount();
        int read = 0;
        int i = 0;
        while (read < response_byte_count) {
            byte[] buffer;
            int record_byte_count = fifo.read() * 2;
            if (fifo.read() != 6) {
                throw new ModbusNumberException("Reference type mismatch.");
            }
            if (record_byte_count > response_byte_count - (read += 2)) {
                record_byte_count = response_byte_count - read;
            }
            if (fifo.read(buffer = new byte[record_byte_count]) != record_byte_count) {
                throw new ModbusNumberException(String.valueOf(record_byte_count) + " bytes expected, but not received.");
            }
            read += record_byte_count;
            ModbusFileRecord mfr = new ModbusFileRecord(0, i++, DataUtils.toIntArray(buffer));
            records.add(mfr);
        }
        this.setFileRecords(records.toArray(new ModbusFileRecord[records.size()]));
    }

    @Override
    protected void writeData(ModbusOutputStream fifo) throws IOException {
        ModbusFileRecord[] modbusFileRecordArray = this.getFileRecords();
        int n = modbusFileRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModbusFileRecord r = modbusFileRecordArray[n2];
            fifo.write(r.getRecordLength());
            fifo.write(6);
            fifo.write(DataUtils.toByteArray(r.getRegisters()));
            ++n2;
        }
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_FILE_RECORD.toInt();
    }

    public ModbusFileRecord[] getFileRecords() {
        return Arrays.copyOf(this.fileRecords, this.fileRecords.length);
    }

    public void setFileRecords(ModbusFileRecord[] fileRecords) throws ModbusNumberException {
        this.fileRecords = Arrays.copyOf(fileRecords, fileRecords.length);
        int byteCount = 0;
        ModbusFileRecord[] modbusFileRecordArray = this.getFileRecords();
        int n = modbusFileRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModbusFileRecord r = modbusFileRecordArray[n2];
            byteCount += 2 + r.getRecordLength() * 2;
            ++n2;
        }
        this.setByteCount(byteCount);
    }
}

