/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.AbstractReadResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DataUtils;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class ReadHoldingRegistersResponse
extends AbstractReadResponse {
    private byte[] buffer;

    public ReadHoldingRegistersResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public final int[] getRegisters() {
        return DataUtils.toIntArray(this.buffer);
    }

    public final void setBuffer(int[] registers) throws ModbusNumberException {
        this.buffer = DataUtils.toByteArray(registers);
        this.setByteCount(this.buffer.length);
    }

    @Override
    protected final void readData(ModbusInputStream fifo) throws IOException {
        this.buffer = new byte[this.getByteCount()];
        int size = fifo.read(this.buffer);
        if (size < this.buffer.length) {
            Modbus.log().warning(String.valueOf(this.buffer.length) + " bytes expected, but " + size + " received.");
        }
    }

    @Override
    protected final void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.buffer);
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_HOLDING_REGISTERS.toInt();
    }
}

