/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.AbstractWriteResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class WriteSingleRegisterResponse
extends AbstractWriteResponse {
    int value;

    public WriteSingleRegisterResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public WriteSingleRegisterResponse(int serverAddress, int startAddress, int value) throws ModbusNumberException {
        super(serverAddress, startAddress);
        this.setValue(value);
        if (!this.checkValue()) {
            throw new ModbusNumberException("Error in register value", startAddress);
        }
    }

    @Override
    protected final void readValue(ModbusInputStream fifo) throws IOException {
        this.setValue(fifo.readShortBE());
    }

    @Override
    protected final void writeValue(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getValue());
    }

    protected boolean checkValue() {
        return Modbus.checkRegisterValue(this.getValue());
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_SINGLE_REGISTER.toInt();
    }

    public final int getValue() {
        return this.value;
    }

    public final void setValue(int value) {
        this.value = (short)value & 0xFFFF;
    }
}

