/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.net.transport.ModbusTransport;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ModbusConnection {
    private int readTimeout = 1000;
    private AtomicBoolean opened = new AtomicBoolean(false);

    public abstract ModbusOutputStream getOutputStream();

    public abstract ModbusInputStream getInputStream();

    public abstract ModbusTransport getTransport();

    public abstract void open() throws ModbusIOException;

    public abstract void close() throws ModbusIOException;

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        ModbusInputStream is;
        this.readTimeout = timeout;
        if (this.getTransport() != null && (is = this.getInputStream()) != null) {
            is.setReadTimeout(timeout);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public boolean isOpened() {
        return this.opened.get();
    }

    public void setOpened(boolean opened) {
        this.opened.set(opened);
    }
}

