/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.net.transport.ModbusTransport;
import com.invertor.modbus.serial.SerialPort;
import com.invertor.modbus.serial.SerialPortException;

abstract class ModbusConnectionSerial
extends ModbusConnection {
    private final SerialPort serial;
    private final ModbusTransport transport;

    ModbusConnectionSerial(SerialPort serial, ModbusTransport transport) {
        this.serial = serial;
        this.transport = transport;
    }

    @Override
    public void open() throws ModbusIOException {
        if (!this.isOpened()) {
            try {
                this.serial.open();
                this.setOpened(true);
            }
            catch (SerialPortException e) {
                throw new ModbusIOException(e);
            }
        }
    }

    @Override
    public void close() {
        this.setOpened(false);
        this.serial.close();
    }

    @Override
    public ModbusOutputStream getOutputStream() {
        return this.transport.getOutputStream();
    }

    @Override
    public ModbusInputStream getInputStream() {
        return this.transport.getInputStream();
    }

    @Override
    public ModbusTransport getTransport() {
        return this.transport;
    }
}

