/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.net.transport.ModbusTransport;
import com.invertor.modbus.net.transport.ModbusTransportFactory;
import com.invertor.modbus.tcp.TcpParameters;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

class ModbusMasterConnectionTCP
extends ModbusConnection {
    private final TcpParameters parameters;
    private ModbusTransport transport = null;

    ModbusMasterConnectionTCP(TcpParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public ModbusOutputStream getOutputStream() {
        return this.transport.getOutputStream();
    }

    @Override
    public ModbusInputStream getInputStream() {
        return this.transport.getInputStream();
    }

    @Override
    public ModbusTransport getTransport() {
        return this.transport;
    }

    @Override
    public void open() throws ModbusIOException {
        if (!this.isOpened() && this.parameters != null) {
            Socket socket = new Socket();
            InetSocketAddress isa = new InetSocketAddress(this.parameters.getHost(), this.parameters.getPort());
            try {
                socket.connect(isa, 3000);
                socket.setKeepAlive(this.parameters.isKeepAlive());
            }
            catch (Exception e) {
                throw new ModbusIOException(e);
            }
            this.transport = ModbusTransportFactory.createTCP(socket);
            this.setReadTimeout(this.getReadTimeout());
            this.setOpened(true);
        }
    }

    @Override
    public void close() throws ModbusIOException {
        this.setOpened(false);
        try {
            try {
                if (this.transport != null) {
                    this.transport.close();
                }
            }
            catch (IOException e) {
                throw new ModbusIOException(e);
            }
        }
        finally {
            this.transport = null;
        }
    }
}

