/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.net.transport.ModbusTransport;
import com.invertor.modbus.net.transport.ModbusTransportFactory;
import java.io.IOException;
import java.net.Socket;

class ModbusSlaveConnectionTCP
extends ModbusConnection {
    private Socket socket;
    private ModbusTransport transport = null;

    ModbusSlaveConnectionTCP(Socket socket) throws ModbusIOException {
        this.socket = socket;
        this.transport = ModbusTransportFactory.createTCP(socket);
        this.open();
    }

    @Override
    public ModbusOutputStream getOutputStream() {
        return this.transport.getOutputStream();
    }

    @Override
    public ModbusInputStream getInputStream() {
        return this.transport.getInputStream();
    }

    @Override
    public ModbusTransport getTransport() {
        return this.transport;
    }

    @Override
    public void open() throws ModbusIOException {
        this.setOpened(true);
    }

    @Override
    public void close() throws ModbusIOException {
        this.setOpened(false);
        try {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                throw new ModbusIOException(e);
            }
        }
        finally {
            this.transport = null;
            this.socket = null;
        }
    }
}

