/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.stream.base;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.utils.ByteFifo;
import com.invertor.modbus.utils.DataUtils;
import java.io.IOException;

public class LoggingInputStream
extends ModbusInputStream {
    private static final String LOG_MESSAGE_TITLE = "Frame recv: ";
    private final ModbusInputStream in;
    private final ByteFifo fifo = new ByteFifo(254);

    public LoggingInputStream(ModbusInputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (Modbus.isLoggingEnabled()) {
            this.fifo.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (Modbus.isLoggingEnabled()) {
            this.fifo.write(b, off, read);
        }
        return read;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.in.setReadTimeout(readTimeout);
    }

    public void log() {
        if (Modbus.isLoggingEnabled()) {
            Modbus.log().info(LOG_MESSAGE_TITLE + DataUtils.toAscii(this.fifo.toByteArray()));
            this.fifo.reset();
        }
    }
}

