/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.transport;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.ModbusMessageFactory;
import com.invertor.modbus.msg.ModbusRequestFactory;
import com.invertor.modbus.msg.ModbusResponseFactory;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.net.stream.base.LoggingInputStream;
import com.invertor.modbus.net.stream.base.LoggingOutputStream;
import java.io.IOException;

public abstract class ModbusTransport {
    private final LoggingInputStream is;
    private final LoggingOutputStream os;

    ModbusTransport(LoggingInputStream is, LoggingOutputStream os) {
        this.is = is;
        this.os = os;
    }

    public void close() throws IOException {
        this.is.close();
        this.os.close();
    }

    public ModbusMessage readRequest() throws ModbusNumberException, ModbusIOException {
        return this.readMessage(ModbusRequestFactory.getInstance());
    }

    public ModbusMessage readResponse() throws ModbusNumberException, ModbusIOException {
        return this.readMessage(ModbusResponseFactory.getInstance());
    }

    public final ModbusMessage readMessage(ModbusMessageFactory factory) throws ModbusNumberException, ModbusIOException {
        try {
            ModbusMessage modbusMessage = this.read(factory);
            return modbusMessage;
        }
        finally {
            this.getInputStream().log();
        }
    }

    public void send(ModbusMessage msg) throws ModbusIOException {
        try {
            this.sendImpl(msg);
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
    }

    public LoggingInputStream getInputStream() {
        return this.is;
    }

    public LoggingOutputStream getOutputStream() {
        return this.os;
    }

    protected abstract ModbusMessage read(ModbusMessageFactory var1) throws ModbusNumberException, ModbusIOException;

    protected abstract void sendImpl(ModbusMessage var1) throws ModbusIOException;
}

